/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.tables.common;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Assertion;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ContractAssertionCellManager
extends AbstractCellManager {
    private static final String NAME = "Name";
    private static final String LANGUAGE = "Language";
    private static final String EXPRESSION = "Expression";
    private static final String DESC = "Description";
    public static final String ASSERTION_TABLE = "AssertionTable";
    public static final String ASSUMPTIONS_TABLE = "AssumptionsTable";
    public static final String GUARANTEES_TABLE = "GuaranteesTable";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager mngr) {
        String type;
        EObject parent;
        return columnElement instanceof IAxis && (parent = ((IAxis)columnElement).eContainer()) != null && (parent = parent.eContainer()) instanceof Table && ((type = ((Table)parent).getTableConfiguration().getType()).equals(ASSERTION_TABLE) || type.equals(GUARANTEES_TABLE) || type.equals(ASSUMPTIONS_TABLE));
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager mngr) {
        boolean isEditable = false;
        if (rowElement instanceof Constraint) {
            isEditable = true;
        }
        return isEditable;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        String value = "";
        String alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        Constraint c = null;
        if (rowElement instanceof Assertion) {
            c = ((Assertion)rowElement).getBase_Constraint();
        } else if (rowElement instanceof Constraint) {
            c = (Constraint)rowElement;
        }
        if (c != null && alias != null) {
            ParameterEntry parameter;
            OpaqueExpression oe = null;
            if (c == null || !(c.getSpecification() instanceof OpaqueExpression)) {
                return null;
            }
            oe = (OpaqueExpression)c.getSpecification();
            if (alias.equals(NAME)) {
                return c.getName();
            }
            if (alias.equals(LANGUAGE)) {
                return oe;
            }
            if (alias.equals(EXPRESSION)) {
                return oe;
            }
            if (alias.equals(DESC) && c != null && (parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)c, ParameterEntry.class)) != null) {
                return parameter.getDescription();
            }
        }
        return value;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        String text;
        String alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        Constraint constraint = (Constraint)rowElement;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)constraint);
        CompositeCommand editingCommand = new CompositeCommand(null);
        if (newValue instanceof String && (text = (String)newValue) != null && alias.equals(NAME)) {
            SetRequest setNameReq = new SetRequest(domain, (EObject)constraint, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)text);
            editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)setNameReq));
        }
        return new GMFtoEMFCommandWrapper((ICommand)editingCommand);
    }
}

