/*
 * generated by Xtext 2.27.0
 */
package org.eclipse.papyrus.robotics.assertions.languages.stl.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.papyrus.robotics.assertions.languages.stl.ide.contentassist.antlr.internal.InternalSTLParser;
import org.eclipse.papyrus.robotics.assertions.languages.stl.services.STLGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class STLParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(STLGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, STLGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getExpression_startAccess().getAlternatives(), "rule__Expression_start__Alternatives");
			builder.put(grammarAccess.getExpression_contAccess().getAlternatives(), "rule__Expression_cont__Alternatives");
			builder.put(grammarAccess.getExpression_contAccess().getAlternatives_10_1(), "rule__Expression_cont__Alternatives_10_1");
			builder.put(grammarAccess.getReal_expressionAccess().getAlternatives(), "rule__Real_expression__Alternatives");
			builder.put(grammarAccess.getReal_expression_nlAccess().getAlternatives(), "rule__Real_expression_nl__Alternatives");
			builder.put(grammarAccess.getComparisonOpAccess().getAlternatives(), "rule__ComparisonOp__Alternatives");
			builder.put(grammarAccess.getNum_literalAccess().getAlternatives(), "rule__Num_literal__Alternatives");
			builder.put(grammarAccess.getIntervalAccess().getAlternatives_2(), "rule__Interval__Alternatives_2");
			builder.put(grammarAccess.getIntervalTimeAccess().getAlternatives(), "rule__IntervalTime__Alternatives");
			builder.put(grammarAccess.getNotOperatorAccess().getAlternatives(), "rule__NotOperator__Alternatives");
			builder.put(grammarAccess.getOrOperatorAccess().getAlternatives(), "rule__OrOperator__Alternatives");
			builder.put(grammarAccess.getAndOperatorAccess().getAlternatives(), "rule__AndOperator__Alternatives");
			builder.put(grammarAccess.getIffOperatorAccess().getAlternatives(), "rule__IffOperator__Alternatives");
			builder.put(grammarAccess.getImpliesOperatorAccess().getAlternatives(), "rule__ImpliesOperator__Alternatives");
			builder.put(grammarAccess.getAlwaysOperatorAccess().getAlternatives(), "rule__AlwaysOperator__Alternatives");
			builder.put(grammarAccess.getEventuallyOperatorAccess().getAlternatives(), "rule__EventuallyOperator__Alternatives");
			builder.put(grammarAccess.getUntilOperatorAccess().getAlternatives(), "rule__UntilOperator__Alternatives");
			builder.put(grammarAccess.getUnlessOperatorAccess().getAlternatives(), "rule__UnlessOperator__Alternatives");
			builder.put(grammarAccess.getHistoricallyOperatorAccess().getAlternatives(), "rule__HistoricallyOperator__Alternatives");
			builder.put(grammarAccess.getOnceOperatorAccess().getAlternatives(), "rule__OnceOperator__Alternatives");
			builder.put(grammarAccess.getSinceOperatorAccess().getAlternatives(), "rule__SinceOperator__Alternatives");
			builder.put(grammarAccess.getNextOperatorAccess().getAlternatives(), "rule__NextOperator__Alternatives");
			builder.put(grammarAccess.getPreviousOperatorAccess().getAlternatives(), "rule__PreviousOperator__Alternatives");
			builder.put(grammarAccess.getEqualOperatorAccess().getAlternatives(), "rule__EqualOperator__Alternatives");
			builder.put(grammarAccess.getNotEqualOperatorAccess().getAlternatives(), "rule__NotEqualOperator__Alternatives");
			builder.put(grammarAccess.getBooleanLiteralAccess().getAlternatives(), "rule__BooleanLiteral__Alternatives");
			builder.put(grammarAccess.getTRUEAccess().getAlternatives(), "rule__TRUE__Alternatives");
			builder.put(grammarAccess.getFALSEAccess().getAlternatives(), "rule__FALSE__Alternatives");
			builder.put(grammarAccess.getAssignmentAccess().getGroup(), "rule__Assignment__Group__0");
			builder.put(grammarAccess.getExpressionAccess().getGroup(), "rule__Expression__Group__0");
			builder.put(grammarAccess.getExpression_startAccess().getGroup_1(), "rule__Expression_start__Group_1__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_0(), "rule__Expression_cont__Group_0__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_1(), "rule__Expression_cont__Group_1__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_2(), "rule__Expression_cont__Group_2__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_3(), "rule__Expression_cont__Group_3__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_4(), "rule__Expression_cont__Group_4__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_5(), "rule__Expression_cont__Group_5__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_6(), "rule__Expression_cont__Group_6__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_7(), "rule__Expression_cont__Group_7__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_8(), "rule__Expression_cont__Group_8__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_9(), "rule__Expression_cont__Group_9__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_10(), "rule__Expression_cont__Group_10__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_11(), "rule__Expression_cont__Group_11__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_12(), "rule__Expression_cont__Group_12__0");
			builder.put(grammarAccess.getExpression_contAccess().getGroup_13(), "rule__Expression_cont__Group_13__0");
			builder.put(grammarAccess.getReal_expressionAccess().getGroup_2(), "rule__Real_expression__Group_2__0");
			builder.put(grammarAccess.getReal_expressionAccess().getGroup_3(), "rule__Real_expression__Group_3__0");
			builder.put(grammarAccess.getReal_expressionAccess().getGroup_4(), "rule__Real_expression__Group_4__0");
			builder.put(grammarAccess.getReal_expressionAccess().getGroup_5(), "rule__Real_expression__Group_5__0");
			builder.put(grammarAccess.getReal_expression_nlAccess().getGroup_0(), "rule__Real_expression_nl__Group_0__0");
			builder.put(grammarAccess.getReal_expression_nlAccess().getGroup_1(), "rule__Real_expression_nl__Group_1__0");
			builder.put(grammarAccess.getReal_expression_nlAccess().getGroup_2(), "rule__Real_expression_nl__Group_2__0");
			builder.put(grammarAccess.getReal_expression_nlAccess().getGroup_3(), "rule__Real_expression_nl__Group_3__0");
			builder.put(grammarAccess.getNum_literalAccess().getGroup_2(), "rule__Num_literal__Group_2__0");
			builder.put(grammarAccess.getIntervalAccess().getGroup(), "rule__Interval__Group__0");
			builder.put(grammarAccess.getIntervalTimeAccess().getGroup_0(), "rule__IntervalTime__Group_0__0");
			builder.put(grammarAccess.getIntervalTimeAccess().getGroup_1(), "rule__IntervalTime__Group_1__0");
			builder.put(grammarAccess.getAssignmentsAccess().getAssignmentsAssignment(), "rule__Assignments__AssignmentsAssignment");
			builder.put(grammarAccess.getAssignmentAccess().getIdAssignment_0(), "rule__Assignment__IdAssignment_0");
			builder.put(grammarAccess.getAssignmentAccess().getExprAssignment_2(), "rule__Assignment__ExprAssignment_2");
			builder.put(grammarAccess.getExpressionAccess().getFirstAssignment_0(), "rule__Expression__FirstAssignment_0");
			builder.put(grammarAccess.getExpressionAccess().getEcAssignment_1(), "rule__Expression__EcAssignment_1");
			builder.put(grammarAccess.getExpression_startAccess().getRAssignment_0(), "rule__Expression_start__RAssignment_0");
			builder.put(grammarAccess.getExpression_startAccess().getE1Assignment_1_1(), "rule__Expression_start__E1Assignment_1_1");
			builder.put(grammarAccess.getExpression_startAccess().getE2Assignment_1_3(), "rule__Expression_start__E2Assignment_1_3");
			builder.put(grammarAccess.getExpression_contAccess().getIAssignment_0_1(), "rule__Expression_cont__IAssignment_0_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_0_2(), "rule__Expression_cont__EAssignment_0_2");
			builder.put(grammarAccess.getExpression_contAccess().getIAssignment_1_1(), "rule__Expression_cont__IAssignment_1_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_1_2(), "rule__Expression_cont__EAssignment_1_2");
			builder.put(grammarAccess.getExpression_contAccess().getIAssignment_2_1(), "rule__Expression_cont__IAssignment_2_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_2_2(), "rule__Expression_cont__EAssignment_2_2");
			builder.put(grammarAccess.getExpression_contAccess().getIAssignment_3_1(), "rule__Expression_cont__IAssignment_3_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_3_2(), "rule__Expression_cont__EAssignment_3_2");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_4_2(), "rule__Expression_cont__EAssignment_4_2");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_5_2(), "rule__Expression_cont__EAssignment_5_2");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_6_1(), "rule__Expression_cont__EAssignment_6_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_7_1(), "rule__Expression_cont__EAssignment_7_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_8_1(), "rule__Expression_cont__EAssignment_8_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_9_1(), "rule__Expression_cont__EAssignment_9_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_10_1_0(), "rule__Expression_cont__EAssignment_10_1_0");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_10_1_1(), "rule__Expression_cont__EAssignment_10_1_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_11_1(), "rule__Expression_cont__EAssignment_11_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_12_1(), "rule__Expression_cont__EAssignment_12_1");
			builder.put(grammarAccess.getExpression_contAccess().getEAssignment_13_1(), "rule__Expression_cont__EAssignment_13_1");
			builder.put(grammarAccess.getReal_expressionAccess().getIdAssignment_0(), "rule__Real_expression__IdAssignment_0");
			builder.put(grammarAccess.getReal_expressionAccess().getLitAssignment_1(), "rule__Real_expression__LitAssignment_1");
			builder.put(grammarAccess.getReal_expressionAccess().getExpAssignment_2_2(), "rule__Real_expression__ExpAssignment_2_2");
			builder.put(grammarAccess.getReal_expressionAccess().getExpAssignment_3_2(), "rule__Real_expression__ExpAssignment_3_2");
			builder.put(grammarAccess.getReal_expressionAccess().getExpAssignment_4_2(), "rule__Real_expression__ExpAssignment_4_2");
			builder.put(grammarAccess.getReal_expressionAccess().getExp1Assignment_5_2(), "rule__Real_expression__Exp1Assignment_5_2");
			builder.put(grammarAccess.getReal_expressionAccess().getExp2Assignment_5_4(), "rule__Real_expression__Exp2Assignment_5_4");
			builder.put(grammarAccess.getReal_expression_nlAccess().getExpAssignment_0_1(), "rule__Real_expression_nl__ExpAssignment_0_1");
			builder.put(grammarAccess.getReal_expression_nlAccess().getExpAssignment_1_1(), "rule__Real_expression_nl__ExpAssignment_1_1");
			builder.put(grammarAccess.getReal_expression_nlAccess().getExpAssignment_2_1(), "rule__Real_expression_nl__ExpAssignment_2_1");
			builder.put(grammarAccess.getReal_expression_nlAccess().getExpAssignment_3_1(), "rule__Real_expression_nl__ExpAssignment_3_1");
			builder.put(grammarAccess.getNum_literalAccess().getIlitAssignment_0(), "rule__Num_literal__IlitAssignment_0");
			builder.put(grammarAccess.getNum_literalAccess().getRlitAssignment_1(), "rule__Num_literal__RlitAssignment_1");
			builder.put(grammarAccess.getNum_literalAccess().getLitAssignment_2_1(), "rule__Num_literal__LitAssignment_2_1");
			builder.put(grammarAccess.getIntervalAccess().getTime1Assignment_1(), "rule__Interval__Time1Assignment_1");
			builder.put(grammarAccess.getIntervalAccess().getTime2Assignment_3(), "rule__Interval__Time2Assignment_3");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private STLGrammarAccess grammarAccess;

	@Override
	protected InternalSTLParser createParser() {
		InternalSTLParser result = new InternalSTLParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public STLGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(STLGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
	
	public NameMappings getNameMappings() {
		return nameMappings;
	}
	
	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
