/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.animation.core.runnables;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.bt.animation.core.rendering.AnimationRenderer;
import org.eclipse.papyrus.robotics.bt.animation.core.utils.BTAnimationResourceManager;
import org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.lib.BTMLVisitorPreOrderTraversalIterative;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;

public abstract class BehaviorTreeAnimator
implements Runnable {
    protected AnimationRenderer _renderer = new AnimationRenderer();
    protected Activity _tr;
    protected BTMLVisitorPreOrderTraversalIterative _visitor;
    protected Map<Integer, ActivityNode> _uid_to_node;
    protected Map<Integer, ActivityEdge> _uid_to_incomingedge;
    protected BTAnimationResourceManager _rm;

    protected boolean emptyMaps() {
        return !(this._uid_to_node != null && !this._uid_to_node.isEmpty() || this._uid_to_incomingedge != null && !this._uid_to_incomingedge.isEmpty());
    }

    protected void updateMaps(int key, Action node) {
        if (node != null) {
            this._uid_to_node.put(key, (ActivityNode)node);
            EList ctrlFlowEdges = node.getIncomings();
            if (!ctrlFlowEdges.isEmpty()) {
                this._uid_to_incomingedge.put(key, (ActivityEdge)node.getIncomings().get(0));
            }
        }
    }

    protected void instantiateMaps() {
        this._uid_to_node = new HashMap<Integer, ActivityNode>();
        this._uid_to_incomingedge = new HashMap<Integer, ActivityEdge>();
    }

    public BehaviorTreeAnimator(Activity btr) throws Exception {
        this._tr = btr;
        this._visitor = new BTMLVisitorPreOrderTraversalIterative(this._tr);
        this.instantiateMaps();
        this._rm = BTAnimationResourceManager.getInstance();
    }

    public void buildMaps(int[] uids) {
        int i = 0;
        while (this._visitor.hasNext()) {
            try {
                if (i == uids.length) break;
                this.updateMaps(uids[i++], this._visitor.visitNext());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stop();
            }
        }
        if (i < uids.length || i == uids.length && this._visitor.hasNext()) {
            Exception e = new Exception("The number of nodes in the diagram and from the run-time BT description does not match!");
            e.printStackTrace();
            this.stop();
        }
    }

    public void dispose() throws Exception {
        this._visitor = new BTMLVisitorPreOrderTraversalIterative(this._tr);
    }

    public void stop() {
        this._renderer.deleteAllMarkers();
        this._visitor.dispose();
    }
}

