/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.animation.core.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.PapyrusMarkerAdapter;
import org.eclipse.papyrus.robotics.bt.animation.core.rendering.AnimationKind;
import org.eclipse.papyrus.robotics.bt.animation.core.utils.BTAnimationUtils;

public class AnimationRenderer {
    protected Map<EObject, List<IPapyrusMarker>> modelElementMarkers = new HashMap<EObject, List<IPapyrusMarker>>();

    public boolean hasMarker(EObject modelElement, AnimationKind kind) {
        if (modelElement == null) {
            return false;
        }
        List<IPapyrusMarker> markers = this.modelElementMarkers.get(modelElement);
        if (markers == null || markers.isEmpty()) {
            return false;
        }
        boolean found = false;
        int i = 0;
        while (!found && i < markers.size()) {
            IPapyrusMarker marker = markers.get(i);
            String type = "";
            try {
                type = marker.getType();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (kind == AnimationKind.RUNNING) {
                found = type.equals(BTAnimationUtils.RUNNING_MARKER_ID);
            } else if (kind == AnimationKind.SUCCESS) {
                found = type.equals(BTAnimationUtils.SUCCESS_MARKER_ID);
            } else if (kind == AnimationKind.FAILURE) {
                found = type.equals(BTAnimationUtils.FAILURE_MARKER_ID);
            } else if (kind == AnimationKind.VISITED) {
                found = type.equals(BTAnimationUtils.VISITED_MARKER_ID);
            }
            ++i;
        }
        return found;
    }

    private IPapyrusMarker createMarker(EObject modelElement, String markerID, Map attributes) {
        PapyrusMarkerAdapter marker = null;
        if (modelElement == null || modelElement.eResource() == null) {
            return null;
        }
        String uri = EcoreUtil.getURI((EObject)modelElement).toString();
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        IResource resource = this.getWorkspaceResource(modelElement);
        if (resource != null && resource.exists()) {
            IMarker newMarker = null;
            try {
                newMarker = resource.createMarker(markerID);
                newMarker.setAttributes(attributes);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (newMarker != null) {
                marker = PapyrusMarkerAdapter.wrap((Resource)modelElement.eResource(), (IMarker)newMarker, (Map)attributes);
            }
        }
        return marker;
    }

    private void deleteMarkers(EObject modelElement) {
        List<IPapyrusMarker> markers = this.modelElementMarkers.get(modelElement);
        if (markers != null && !markers.isEmpty()) {
            for (IPapyrusMarker currentMarker : markers) {
                try {
                    currentMarker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.modelElementMarkers.get(modelElement).clear();
        }
    }

    private IResource getWorkspaceResource(EObject modelElement) {
        IFile resource = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            resource = workspace.getRoot().getFile((IPath)new Path(modelElement.eResource().getURI().toPlatformString(true)));
        }
        return resource;
    }

    public void deleteAllMarkers() {
        for (EObject modelElement : this.modelElementMarkers.keySet()) {
            for (IPapyrusMarker marker : this.modelElementMarkers.get(modelElement)) {
                if (!marker.exists()) continue;
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.modelElementMarkers.get(modelElement).clear();
        }
        this.modelElementMarkers.clear();
    }

    public void renderAs(EObject modelElement, AnimationKind targetStyle) {
        IPapyrusMarker requestedMarker = null;
        this.deleteMarkers(modelElement);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("uri", EcoreUtil.getURI((EObject)modelElement).toString());
        if (targetStyle.equals((Object)AnimationKind.RUNNING)) {
            requestedMarker = this.createMarker(modelElement, BTAnimationUtils.RUNNING_MARKER_ID, attributes);
        } else if (targetStyle.equals((Object)AnimationKind.SUCCESS)) {
            requestedMarker = this.createMarker(modelElement, BTAnimationUtils.SUCCESS_MARKER_ID, attributes);
        } else if (targetStyle.equals((Object)AnimationKind.FAILURE)) {
            requestedMarker = this.createMarker(modelElement, BTAnimationUtils.FAILURE_MARKER_ID, attributes);
        } else if (targetStyle.equals((Object)AnimationKind.VISITED)) {
            requestedMarker = this.createMarker(modelElement, BTAnimationUtils.VISITED_MARKER_ID, attributes);
        } else {
            System.err.println("[renderAs] - animation kind not recognized");
        }
        List<IPapyrusMarker> markerList = this.modelElementMarkers.get(modelElement);
        if (markerList == null) {
            markerList = new ArrayList<IPapyrusMarker>();
            this.modelElementMarkers.put(modelElement, markerList);
        }
        if (requestedMarker != null) {
            markerList.add(requestedMarker);
        }
    }
}

