/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.Parameter;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class ParameterUtils {
    public static List<Property> getAllParameters(Class clazz) {
        ArrayList<Property> parameterList = new ArrayList<Property>();
        for (Class superClass : clazz.getSuperClasses()) {
            Class paramClass = ParameterUtils.getParameterClass(superClass);
            if (paramClass == null) continue;
            parameterList.addAll((Collection<Property>)paramClass.getOwnedAttributes());
        }
        Class paramClass = ParameterUtils.getParameterClass(clazz);
        if (paramClass != null) {
            parameterList.addAll((Collection<Property>)paramClass.getOwnedAttributes());
        }
        return parameterList;
    }

    public static Class getParameterClass(Class component) {
        for (Classifier cl : component.getNestedClassifiers()) {
            if (!(cl instanceof Class) || !StereotypeUtil.isApplied((Element)cl, Parameter.class)) continue;
            return (Class)cl;
        }
        return null;
    }

    public static Property getParameterProperty(Class nestedClassifier) {
        Element owner = nestedClassifier.getOwner();
        if (owner instanceof Class) {
            for (Property p : ((Class)owner).getOwnedAttributes()) {
                if (p.getType() != nestedClassifier) continue;
                return p;
            }
        }
        return null;
    }
}

