/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.verfication.rules;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class TextShouldBeSyntacticallyDifferent
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext context) {
        Class clazz = (Class)context.getTarget();
        EMFEventType eType = context.getEventType();
        double normalizedSimilarityIndex = 0.0;
        int distance = 0;
        String text2 = "";
        String text1 = "";
        if (eType == EMFEventType.NULL && clazz.getAppliedStereotype("SysML::Requirements::Requirement") != null) {
            text1 = (String)clazz.getValue(clazz.getAppliedStereotype("SysML::Requirements::Requirement"), "text");
            for (Element element : clazz.getModel().allOwnedElements()) {
                if (element.equals(clazz) || element.getAppliedStereotype("SysML::Requirements::Requirement") == null) continue;
                text2 = (String)element.getValue(element.getAppliedStereotype("SysML::Requirements::Requirement"), "text");
                distance = StringUtils.getLevenshteinDistance((String)text1, (String)text2);
                normalizedSimilarityIndex = (double)distance / (double)Math.max(text1.length(), text2.length());
                if (normalizedSimilarityIndex <= 0.2) {
                    return context.createFailureStatus(new Object[]{String.valueOf(clazz.getName()) + " has " + (1.0 - normalizedSimilarityIndex) * 100.0 + "%  of sintactic similarity than requirement " + ((NamedElement)element).getName()});
                }
                if (normalizedSimilarityIndex != 0.0) continue;
                return context.createFailureStatus(new Object[]{String.valueOf(clazz.getName()) + " has the same text than requirement " + ((NamedElement)element).getName()});
            }
        }
        return context.createSuccessStatus();
    }
}

