/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.extensionpoints.helpers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.metrics.extensionpoints.Activator;
import org.eclipse.papyrus.metrics.extensionpoints.helpers.SmmMetricsModelHelper;
import org.omg.smm.AbstractMeasureElement;
import org.omg.smm.Measure;
import org.omg.smm.MeasureLibrary;
import org.omg.smm.NamedMeasure;
import org.omg.smm.SmmModel;

public class SmmModelRegistry {
    protected static SmmModelRegistry namedMeasuresRegistry = null;
    protected ArrayList<Measure> measures = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.metrics.extensionpoints.smmmetricsmodel";

    public ArrayList<Measure> getMeasures() {
        return this.measures;
    }

    public static String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    public static synchronized SmmModelRegistry getInstance() {
        if (namedMeasuresRegistry == null) {
            namedMeasuresRegistry = new SmmModelRegistry();
            namedMeasuresRegistry.init();
        }
        return namedMeasuresRegistry;
    }

    protected void init() {
        this.measures = null;
        this.measures = new ArrayList();
        this.readExtensions();
    }

    protected void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        SmmModel smmModel = null;
        SmmMetricsModelHelper helper = new SmmMetricsModelHelper();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String fileLocation = element.getAttribute("xmiFile");
            smmModel = helper.getSmmModel(fileLocation);
            if (smmModel != null) {
                for (MeasureLibrary library : smmModel.getLibraries()) {
                    for (AbstractMeasureElement abstractMeasureElement : library.getMeasureElements()) {
                        if (!(abstractMeasureElement instanceof NamedMeasure)) continue;
                        NamedMeasure measure = (NamedMeasure)abstractMeasureElement;
                        this.measures.add((Measure)measure);
                    }
                }
            } else {
                Activator.log.warn(String.format("It was imposible to obtain an SMM model from %s", element.getValue()));
            }
            ++n2;
        }
    }
}

