/**
 * Copyright (c) 2022, 2023 CEA LIST, Obeo
 * 
 *  All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Obeo - Initial API and implementation
 */
package org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols;

import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>EEF Ext Editable Reference Description</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription#getRemoveExpression <em>Remove Expression</em>}</li>
 *   <li>{@link org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription#getCreateExpression <em>Create Expression</em>}</li>
 *   <li>{@link org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription#getBrowseExpression <em>Browse Expression</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EefAdvancedControlsPackage#getEEFExtEditableReferenceDescription()
 * @model
 * @generated
 */
public interface EEFExtEditableReferenceDescription extends EEFExtReferenceDescription {
	/**
	 * Returns the value of the '<em><b>Remove Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Remove Expression</em>' attribute.
	 * @see #setRemoveExpression(String)
	 * @see org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EefAdvancedControlsPackage#getEEFExtEditableReferenceDescription_RemoveExpression()
	 * @model
	 * @generated
	 */
	String getRemoveExpression();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription#getRemoveExpression <em>Remove Expression</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Remove Expression</em>' attribute.
	 * @see #getRemoveExpression()
	 * @generated
	 */
	void setRemoveExpression(String value);

	/**
	 * Returns the value of the '<em><b>Create Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Create Expression</em>' attribute.
	 * @see #setCreateExpression(String)
	 * @see org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EefAdvancedControlsPackage#getEEFExtEditableReferenceDescription_CreateExpression()
	 * @model
	 * @generated
	 */
	String getCreateExpression();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription#getCreateExpression <em>Create Expression</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Create Expression</em>' attribute.
	 * @see #getCreateExpression()
	 * @generated
	 */
	void setCreateExpression(String value);

	/**
	 * Returns the value of the '<em><b>Browse Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Browse Expression</em>' attribute.
	 * @see #setBrowseExpression(String)
	 * @see org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EefAdvancedControlsPackage#getEEFExtEditableReferenceDescription_BrowseExpression()
	 * @model
	 * @generated
	 */
	String getBrowseExpression();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription#getBrowseExpression <em>Browse Expression</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Browse Expression</em>' attribute.
	 * @see #getBrowseExpression()
	 * @generated
	 */
	void setBrowseExpression(String value);

} // EEFExtEditableReferenceDescription
