/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.pssm.profiling.VertexActivationProfiler;
import org.eclipse.papyrus.moka.pssm.statemachines.IPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IRegionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.ITransitionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IVertexActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.StateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMachineExecution;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMachineSemanticVisitor;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMetadata;
import org.eclipse.papyrus.moka.pssm.statemachines.TransitionMetadata;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Vertex;

public abstract class VertexActivation
extends StateMachineSemanticVisitor
implements IVertexActivation {
    protected StateMetadata status;
    protected List<ITransitionActivation> incomingTransitionActivations;
    protected List<ITransitionActivation> outgoingTransitionActivations;

    public VertexActivation() {
        this.setStatus(StateMetadata.IDLE);
        this.incomingTransitionActivations = new ArrayList<ITransitionActivation>();
        this.outgoingTransitionActivations = new ArrayList<ITransitionActivation>();
    }

    public VertexActivation getParentVertexActivation() {
        IRegionActivation regionActivation = (IRegionActivation)this.getParent();
        if (regionActivation != null) {
            if (regionActivation.getParent() instanceof StateMachineExecution) {
                return null;
            }
            return (VertexActivation)regionActivation.getParent();
        }
        return null;
    }

    public IRegionActivation getOwningRegionActivation() {
        return (IRegionActivation)this.parent;
    }

    public void setStatus(StateMetadata state) {
        this.status = state;
    }

    public StateMetadata getStatus() {
        return this.status;
    }

    public void addIncomingTransition(ITransitionActivation activation) {
        this.incomingTransitionActivations.add(activation);
    }

    public void addOutgoingTransition(ITransitionActivation activation) {
        this.outgoingTransitionActivations.add(activation);
    }

    public List<ITransitionActivation> getOutgoingTransitions() {
        return this.outgoingTransitionActivations;
    }

    public List<ITransitionActivation> getIncomingTransitions() {
        return this.incomingTransitionActivations;
    }

    public IVertexActivation getVertexActivation(Vertex vertex) {
        return null;
    }

    public final void tagOutgoingTransitions(TransitionMetadata status, boolean staticCheck) {
        for (ITransitionActivation transitionActivation : this.outgoingTransitionActivations) {
            if (staticCheck) {
                transitionActivation.setAnalyticalStatus(status);
                continue;
            }
            transitionActivation.setStatus(status);
        }
    }

    public final void tagIncomingTransitions(TransitionMetadata status, boolean staticCheck) {
        for (ITransitionActivation transitionActivation : this.incomingTransitionActivations) {
            if (staticCheck) {
                transitionActivation.setAnalyticalStatus(status);
                continue;
            }
            transitionActivation.setStatus(status);
        }
    }

    public List<IVertexActivation> getAscendingHierarchy() {
        ArrayList<IVertexActivation> hierarchy = new ArrayList<IVertexActivation>();
        List<ISemanticVisitor> contextChain = this.getContextChain();
        for (ISemanticVisitor element : contextChain) {
            if (!(element instanceof StateActivation)) continue;
            hierarchy.add((StateActivation)element);
        }
        return hierarchy;
    }

    public void enter(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        IVertexActivation vertexActivation;
        IRegionActivation owningRegionActivation = this.getOwningRegionActivation();
        if (leastCommonAncestor != null && owningRegionActivation != null && leastCommonAncestor != owningRegionActivation && (vertexActivation = (IVertexActivation)owningRegionActivation.getParent()) != null) {
            IRegionActivation iRegionActivation = leastCommonAncestor;
            IEventOccurrence iEventOccurrence = eventOccurrence;
            ITransitionActivation iTransitionActivation = enteringTransition;
            IVertexActivation iVertexActivation = vertexActivation;
            if (iVertexActivation instanceof IPseudostateActivation) {
                VertexActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$2$dfc2c037((IPseudostateActivation)iVertexActivation, iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
            try {
                iVertexActivation.enter(iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
            finally {
                if (iVertexActivation instanceof IStateActivation) {
                    VertexActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$1$107a5ab5((IStateActivation)iVertexActivation, iTransitionActivation, iEventOccurrence, iRegionActivation);
                }
            }
        }
        this.setStatus(StateMetadata.ACTIVE);
        this.tagOutgoingTransitions(TransitionMetadata.REACHED, false);
    }

    public void exit(ITransitionActivation exitingTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        VertexActivation vertexActivation;
        this.tagIncomingTransitions(TransitionMetadata.NONE, false);
        this.setStatus(StateMetadata.IDLE);
        IRegionActivation owningRegionActivation = this.getOwningRegionActivation();
        if (leastCommonAncestor != null && owningRegionActivation != null && leastCommonAncestor != owningRegionActivation && (vertexActivation = (VertexActivation)owningRegionActivation.getParent()) != null) {
            IRegionActivation iRegionActivation = leastCommonAncestor;
            IEventOccurrence iEventOccurrence = eventOccurrence;
            ITransitionActivation iTransitionActivation = exitingTransition;
            VertexActivation vertexActivation2 = vertexActivation;
            try {
                vertexActivation2.exit(iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
            finally {
                VertexActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$3$a1d3df7a(vertexActivation2, iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
        }
    }

    public boolean isActive() {
        return this.status.equals((Object)StateMetadata.ACTIVE);
    }

    public IRegionActivation getLeastCommonAncestor(IVertexActivation targetVertexActivation, TransitionKind transitionKind) {
        IRegionActivation leastCommonAncestor = null;
        ISemanticVisitor sourceHierachyNode = null;
        ISemanticVisitor targetHierarchyNode = null;
        List<ISemanticVisitor> sourceHierarchy = this.getContextChain();
        List targetHierarchy = targetVertexActivation.getContextChain();
        int sourceHierarchyIndex = sourceHierarchy.size();
        int targetHierarchyIndex = targetHierarchy.size();
        while (leastCommonAncestor == null && sourceHierarchyIndex > 0 && targetHierarchyIndex > 0) {
            sourceHierachyNode = sourceHierarchy.get(sourceHierarchyIndex - 1);
            if (sourceHierachyNode != (targetHierarchyNode = (ISemanticVisitor)targetHierarchy.get(targetHierarchyIndex - 1))) {
                leastCommonAncestor = this.getRegionActivation(sourceHierachyNode);
                continue;
            }
            --sourceHierarchyIndex;
            --targetHierarchyIndex;
        }
        if (leastCommonAncestor == null) {
            leastCommonAncestor = sourceHierarchyIndex == 0 && targetHierarchyIndex == 0 ? this.getRegionActivation(sourceHierarchy.get(sourceHierarchyIndex + 1)) : (this.getVertexActivation((Vertex)targetVertexActivation.getNode()) != null ? (transitionKind == TransitionKind.EXTERNAL_LITERAL ? this.getRegionActivation(sourceHierarchy.get(sourceHierarchyIndex)) : this.getRegionActivation((ISemanticVisitor)targetHierarchy.get(targetHierarchyIndex - 1))) : this.getRegionActivation(sourceHierarchy.get(sourceHierarchyIndex - 1)));
        }
        return leastCommonAncestor;
    }

    private IRegionActivation getRegionActivation(ISemanticVisitor semanticVisitor) {
        IRegionActivation regionActivation = null;
        if (semanticVisitor instanceof IRegionActivation) {
            regionActivation = (IRegionActivation)semanticVisitor;
        } else if (semanticVisitor instanceof VertexActivation) {
            regionActivation = (IRegionActivation)((IVertexActivation)semanticVisitor).getParent();
        }
        return regionActivation;
    }

    public boolean isEnterable(ITransitionActivation enteringTransition, boolean staticCheck) {
        return true;
    }

    public boolean isExitable(ITransitionActivation exitingTransition, boolean staticCheck) {
        return true;
    }

    public void terminate() {
    }

    public boolean canPropagateExecution(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        IVertexActivation vertexActivation;
        IRegionActivation parentRegionActivation;
        boolean propagate = true;
        if (leastCommonAncestor != null && leastCommonAncestor != (parentRegionActivation = this.getOwningRegionActivation()) && (vertexActivation = (IVertexActivation)parentRegionActivation.getParent()) != null) {
            propagate = vertexActivation.canPropagateExecution(enteringTransition, eventOccurrence, leastCommonAncestor);
        }
        return propagate;
    }
}

