/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import java.util.Iterator;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.pssm.profiling.VertexActivationProfiler;
import org.eclipse.papyrus.moka.pssm.statemachines.IHistoryPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IRegionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateMachineExecution;
import org.eclipse.papyrus.moka.pssm.statemachines.ITransitionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.PseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMetadata;
import org.eclipse.papyrus.moka.pssm.statemachines.VertexActivation;
import org.eclipse.uml2.uml.State;

public abstract class HistoryPseudostateActivation
extends PseudostateActivation
implements IHistoryPseudostateActivation {
    public boolean hasDefaultTransition() {
        boolean defaultTransition = false;
        if (this.outgoingTransitionActivations.size() == 1) {
            defaultTransition = true;
        }
        return defaultTransition;
    }

    @Override
    public void enter(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        VertexActivation parentVertexActivation = this.getParentVertexActivation();
        if (parentVertexActivation != null) {
            IRegionActivation owningRegionActivation = this.getOwningRegionActivation();
            if (owningRegionActivation.getHistory() == null && !this.hasDefaultTransition()) {
                super.enter(enteringTransition, eventOccurrence, leastCommonAncestor);
            } else {
                parentVertexActivation = (IStateActivation)parentVertexActivation;
                parentVertexActivation.setStatus(StateMetadata.ACTIVE);
                super.enter(enteringTransition, eventOccurrence, leastCommonAncestor);
                this.restore((IStateActivation)parentVertexActivation, enteringTransition, eventOccurrence);
            }
        } else {
            IRegionActivation owningRegionActivation = this.getOwningRegionActivation();
            if (owningRegionActivation.getHistory() == null && !this.hasDefaultTransition()) {
                owningRegionActivation.enter(enteringTransition, eventOccurrence);
            } else {
                this.restore(owningRegionActivation, enteringTransition, eventOccurrence);
            }
        }
        if (this.isActive()) {
            IRegionActivation iRegionActivation = null;
            IEventOccurrence iEventOccurrence = null;
            ITransitionActivation iTransitionActivation = null;
            HistoryPseudostateActivation historyPseudostateActivation = this;
            try {
                historyPseudostateActivation.exit(iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
            finally {
                VertexActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$3$a1d3df7a(historyPseudostateActivation, iTransitionActivation, iEventOccurrence, iRegionActivation);
            }
        }
    }

    public void restore(IStateActivation stateActivation, ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence) {
        State state = (State)stateActivation.getNode();
        stateActivation.setStatus(StateMetadata.ACTIVE);
        IStateMachineExecution smExecution = (IStateMachineExecution)this.getStateMachineExecution();
        smExecution.getConfiguration().register(stateActivation);
        stateActivation.setEntryCompletion(state.getEntry() == null);
        stateActivation.setDoActivityCompletion(state.getDoActivity() == null);
        stateActivation.setExitCompletion(state.getExit() == null);
        if (stateActivation.hasCompleted()) {
            stateActivation.complete();
        } else {
            stateActivation.tryExecuteEntry(eventOccurrence);
            stateActivation.tryInvokeDoActivity(eventOccurrence);
            Iterator regionActivationsIterator = stateActivation.getRegionActivation().iterator();
            while (regionActivationsIterator.hasNext()) {
                this.restore((IRegionActivation)regionActivationsIterator.next(), enteringTransition, eventOccurrence);
            }
        }
    }

    public abstract void restore(IRegionActivation var1, ITransitionActivation var2, IEventOccurrence var3);
}

