/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IObjectActivation;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.Object_;
import org.eclipse.papyrus.moka.pssm.commonbehavior.ISM_ObjectActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.DoActivityContextObjectActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.DoActivityExecutionEventAccepter;
import org.eclipse.papyrus.moka.pssm.statemachines.IDeferredEventOccurrence;
import org.eclipse.papyrus.moka.pssm.statemachines.IDoActivityContextObject;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateActivation;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.StructuralFeature;

public class DoActivityContextObject
extends Object_
implements IDoActivityContextObject {
    public IStateActivation owner;
    public IObject_ context;

    public IObject_ getContext() {
        return this.context;
    }

    public void initialize(IObject_ context) {
        if (context != null) {
            this.context = context;
        }
    }

    public void startBehavior(Class classifier, List<IParameterValue> inputs) {
        if (this.objectActivation == null) {
            this.objectActivation = new DoActivityContextObjectActivation();
            this.objectActivation.setObject((IObject_)this);
        }
        this.objectActivation.startBehavior(classifier, inputs);
    }

    public void register(IEventAccepter accepter) {
        super.register(accepter);
        ISM_ObjectActivation contextObjectActivation = (ISM_ObjectActivation)this.context.getObjectActivation();
        int i = 1;
        IDeferredEventOccurrence matchedDeferredEvent = null;
        while (matchedDeferredEvent == null && i <= contextObjectActivation.getDeferredEvents().size()) {
            IDeferredEventOccurrence eventOccurrence = (IDeferredEventOccurrence)contextObjectActivation.getDeferredEvents().get(i - 1);
            if (this.owner == eventOccurrence.getConstrainingStateActivation() && accepter.match(eventOccurrence.getDeferredEventOccurrence()).booleanValue()) {
                matchedDeferredEvent = eventOccurrence;
            }
            ++i;
        }
        if (matchedDeferredEvent == null) {
            DoActivityExecutionEventAccepter encapsulatingAccepter = new DoActivityExecutionEventAccepter();
            encapsulatingAccepter.encapsulatedAccepter = accepter;
            encapsulatingAccepter.context = this;
            this.context.register((IEventAccepter)encapsulatingAccepter);
        } else {
            contextObjectActivation.getDeferredEvents().remove(matchedDeferredEvent);
            this.objectActivation.getEvents().add(matchedDeferredEvent.getDeferredEventOccurrence());
            this.objectActivation.notifyEventArrival();
        }
    }

    public IFeatureValue getFeatureValue(StructuralFeature feature) {
        IFeatureValue featureValue = null;
        if (this.context != null) {
            featureValue = this.context.getFeatureValue(feature);
        }
        return featureValue;
    }

    public void setFeatureValue(StructuralFeature feature, List<IValue> values, Integer position) {
        if (this.context != null) {
            this.context.setFeatureValue(feature, values, position);
        }
    }

    public IExecution dispatch(Operation operation) {
        IExecution execution = null;
        if (this.context != null) {
            execution = this.context.dispatch(operation);
        }
        return execution;
    }

    public void send(IEventOccurrence eventOccurrence) {
        if (this.context != null) {
            this.context.send(eventOccurrence);
        }
    }

    public void destroy() {
        int i = 0;
        while (i < this.objectActivation.getWaitingEventAccepters().size()) {
            this.unregisterFromContext((IEventAccepter)this.objectActivation.getWaitingEventAccepters().get(i));
            ++i;
        }
        super.destroy();
    }

    protected void unregisterFromContext(IEventAccepter encapsulatedAccepter) {
        IObjectActivation contextObjectActivation = this.context.getObjectActivation();
        if (contextObjectActivation != null) {
            DoActivityExecutionEventAccepter encapsulatingAccepter = null;
            int i = 0;
            while (encapsulatingAccepter == null && i < contextObjectActivation.getWaitingEventAccepters().size()) {
                IEventAccepter currentAccepter = (IEventAccepter)contextObjectActivation.getWaitingEventAccepters().get(i);
                if (currentAccepter instanceof DoActivityExecutionEventAccepter && ((DoActivityExecutionEventAccepter)currentAccepter).encapsulatedAccepter == encapsulatedAccepter) {
                    encapsulatingAccepter = (DoActivityExecutionEventAccepter)currentAccepter;
                }
                ++i;
            }
            if (encapsulatingAccepter != null) {
                contextObjectActivation.unregister(encapsulatingAccepter);
            }
        }
    }
}

