/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine;

import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.animation.engine.animators.Animator;
import org.eclipse.papyrus.moka.animation.engine.animators.AnimatorExtensionEvaluator;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationEngine;
import org.eclipse.papyrus.moka.animation.engine.rendering.IAnimation;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.kernel.service.ExecutionEngineService;

public abstract class AnimationService
extends ExecutionEngineService<IExecutionEngine>
implements IAnimation {
    protected AnimationEngine engine = new AnimationEngine();
    protected List<Animator> animators = AnimatorExtensionEvaluator.evaluateAnimators(this.engine);

    public void init(ILaunch launcher, EObject modelElement) {
        this.engine.init(modelElement);
    }

    public Animator getAnimator(ISemanticVisitor nodeVisitor) {
        Animator animator = null;
        for (Animator current : this.animators) {
            if (!current.accept(nodeVisitor)) continue;
            animator = animator != null ? (current.getPriority() > animator.getPriority() ? current : animator) : current;
        }
        return animator;
    }

    public AnimationEngine getEngine() {
        return this.engine;
    }
}

