/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml;

import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.moka.engine.schedulable.AbstractScheduledExecutionEngine;
import org.eclipse.papyrus.moka.engine.uml.IUMLExecutionEngine;
import org.eclipse.papyrus.moka.engine.uml.UMLExecutionEngineHelper;
import org.eclipse.papyrus.moka.engine.uml.scheduling.UMLTaskExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLTaskExecutionFactory;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;

public abstract class AbstractUMLExecutionEngine
extends AbstractScheduledExecutionEngine
implements IUMLExecutionEngine {
    protected ILocus locus;
    protected IUMLTaskExecutionFactory rootTaskFactory;

    protected void init(EngineConfiguration<?> configuration, SubMonitor monitor) {
        super.init(configuration, monitor);
        this.locus = this.createLocus();
        this.rootTaskFactory = this.createUMLTaskFactory();
        this.locus.getFactory().setTaskFactory(this.rootTaskFactory);
        this.installBuiltInTypes();
        this.installLibraries();
        this.installSemanticStrategies();
    }

    protected IUMLTaskExecutionFactory createUMLTaskFactory() {
        return new UMLTaskExecutionFactory(this.controller.getExecutionLoop());
    }

    @Override
    public ILocus createLocus() {
        return UMLExecutionEngineHelper.createLocus();
    }

    @Override
    public void installBuiltInTypes() {
        UMLExecutionEngineHelper.installBuiltInTypes(this.configuration, this.locus);
    }

    @Override
    public void installLibraries() {
        UMLExecutionEngineHelper.installLibraries(this.configuration, this.locus);
    }

    @Override
    public void installSemanticStrategies() {
        UMLExecutionEngineHelper.installSemanticStrategies(this.locus);
    }
}

