/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.dnd.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.moka.simex.dnd.command.CreateAndDropGenericCommand;
import org.eclipse.papyrus.moka.simex.utils.RequestUtils;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;

public class CreateAndDropLinkActionCommand
extends CreateAndDropGenericCommand {
    public CreateAndDropLinkActionCommand(Activity targetActivity, IElementType elementTypeToCreate, EReference eRefToSet, EObject droppedObject, Point location, GraphicalEditPart targetEditPart) {
        super(targetActivity, elementTypeToCreate, eRefToSet, droppedObject, location, targetEditPart);
    }

    @Override
    protected ActivityNode createNode() {
        ICommand createCommand;
        CreateElementRequest createReq = new CreateElementRequest((EObject)this.targetActivity, this.elementTypeToCreate);
        createReq.getParameters().put("ASSOCIATION", this.droppedObject);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.targetActivity);
        if (provider != null && (createCommand = provider.getEditCommand((IEditCommandRequest)createReq)) != null && createCommand.canExecute()) {
            try {
                createCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            CommandResult result = createCommand.getCommandResult();
            ActivityNode createdNode = (ActivityNode)RequestUtils.getCreatedObject(result);
            String defaultName = this.getDefaultName(createdNode);
            createdNode.setName(defaultName);
            return createdNode;
        }
        return null;
    }
}

