/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.advices;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.UMLPackage;

public class SendSignalActionEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        if (request.getElementToConfigure() instanceof SendSignalAction) {
            final SendSignalAction sendSignal = (SendSignalAction)request.getElementToConfigure();
            AbstractTransactionalCommand ret = new AbstractTransactionalCommand(request.getEditingDomain(), "Complete send signal action creation", Collections.EMPTY_LIST){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Activity activity = sendSignal.containingActivity();
                    if (activity != null && activity.getContext() instanceof EncapsulatedClassifier) {
                        EncapsulatedClassifier context = (EncapsulatedClassifier)activity.getContext();
                        EList ports = context.getOwnedPorts();
                        if (ports.size() == 1) {
                            sendSignal.setOnPort((Port)ports.get(0));
                        } else {
                            Object[] result;
                            TreeSelectorDialog dialog = new TreeSelectorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                            dialog.setTitle("Select port");
                            dialog.setDescription("Select the port through which the signal should be sent");
                            UMLContentProvider provider = new UMLContentProvider((EObject)sendSignal, (EStructuralFeature)UMLPackage.eINSTANCE.getInvocationAction_OnPort());
                            dialog.setContentProvider((ITreeContentProvider)provider);
                            dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
                            dialog.setInitialElementSelections((List)context.getOwnedPorts());
                            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof Port) {
                                sendSignal.setOnPort((Port)result[0]);
                            }
                        }
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            return ret;
        }
        return null;
    }
}

