/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.profile.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.moka.fmi.fmiprofile.CS_FMU;
import org.eclipse.papyrus.moka.fmi.fmiprofile.FMIProfilePackage;
import org.eclipse.papyrus.moka.fmi.fmiprofile.FMU;
import org.eclipse.papyrus.moka.fmi.fmiprofile.FlowDirection;
import org.eclipse.papyrus.moka.fmi.fmiprofile.ME_FMU;
import org.eclipse.papyrus.moka.fmi.fmiprofile.Port;
import org.eclipse.papyrus.moka.fmi.fmiprofile.ScalarVariable;
import org.eclipse.papyrus.moka.fmi.modeldescription.Fmi2ScalarVariable;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiModelDescriptionType;
import org.eclipse.papyrus.moka.fmi.profile.util.FastUMLUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FMIProfileUtil {
    public static final String FMI_PROFILE_URI = "pathmap://PAPYRUS_FMI_PROFILE/FMI.profile.uml";
    public static final String FMI_PROFILE_NAME = "FMIProfile";
    public static final String CS_FMU_STEREO_NAME = FMIProfilePackage.eINSTANCE.getCS_FMU().getName();
    public static final String ME_FMU_STEREO_NAME = FMIProfilePackage.eINSTANCE.getME_FMU().getName();
    public static final String CS_GRAPH_STEREO_NAME = FMIProfilePackage.eINSTANCE.getCS_Graph().getName();
    public static final String CALCULATED_PARAMETER_STEREO_NAME = FMIProfilePackage.eINSTANCE.getCalculatedParameter().getName();
    public static final String PARAMETER_STEREO_NAME = FMIProfilePackage.eINSTANCE.getParameter().getName();
    public static final String LOCAL_STEREO_NAME = FMIProfilePackage.eINSTANCE.getLocal().getName();
    public static final String INDEPENDENT_STEREO_NAME = FMIProfilePackage.eINSTANCE.getIndependent().getName();
    public static final String PORT_STEREO_NAME = FMIProfilePackage.eINSTANCE.getPort().getName();
    public static final String OUTPUT_DEPENDENCY_STEREO_NAME = FMIProfilePackage.eINSTANCE.getOutputDependency().getName();
    public static final String DERIVATIVE_DEPENDENCY_STEREO_NAME = FMIProfilePackage.eINSTANCE.getDerivativeDependency().getName();
    public static final String INITIAL_UNKNWOWN_STEREO_NAME = FMIProfilePackage.eINSTANCE.getInitialUnknownDependency().getName();
    public static final String CS_FMU_STEREO_QUALIFIED_NAME = "FMIProfile::" + CS_FMU_STEREO_NAME;
    public static final String ME_FMU_STEREO_QUALIFIED_NAME = "FMIProfile::" + ME_FMU_STEREO_NAME;
    public static final String CS_GRAPH_STEREO_QUALIFIED_NAME = "FMIProfile::" + CS_GRAPH_STEREO_NAME;
    public static final String CALCULATED_PARAMETER_STEREO_QUALIFIED_NAME = "FMIProfile::" + CALCULATED_PARAMETER_STEREO_NAME;
    public static final String PARAMETER_STEREO_QUALIFIED_NAME = "FMIProfile::" + PARAMETER_STEREO_NAME;
    public static final String LOCAL_STEREO_QUALIFIED_NAME = "FMIProfile::" + LOCAL_STEREO_NAME;
    public static final String INDEPENDENT_STEREO_QUALIFIED_NAME = "FMIProfile::" + INDEPENDENT_STEREO_NAME;
    public static final String PORT_STEREO_QUALIFIED_NAME = "FMIProfile::" + PORT_STEREO_NAME;
    public static final String OUTPUT_DEPENDENCY_STEREO_QUALIFIED_NAME = "FMIProfile::" + OUTPUT_DEPENDENCY_STEREO_NAME;
    public static final String DERIVATIVE_DEPENDENCY_STEREO_QUALIFIED_NAME = "FMIProfile::" + DERIVATIVE_DEPENDENCY_STEREO_NAME;
    public static final String INITIAL_UNKNWOWN_STEREO_QUALIFIED_NAME = "FMIProfile::" + INITIAL_UNKNWOWN_STEREO_NAME;

    public static void applyFMIProfileIfNeeded(Package owningPackage) {
        Profile fmiProfile = FMIProfileUtil.getFMIProfile((EObject)owningPackage);
        Iterator profileIter = owningPackage.getAllAppliedProfiles().iterator();
        Profile appliedProfile = null;
        while (profileIter.hasNext() && appliedProfile != fmiProfile) {
            appliedProfile = (Profile)profileIter.next();
        }
        if (appliedProfile != fmiProfile) {
            Model rootPackage = owningPackage.getModel();
            if (rootPackage != null && rootPackage.eResource() == owningPackage.eResource()) {
                rootPackage.applyProfile(fmiProfile);
            } else {
                owningPackage.applyProfile(fmiProfile);
            }
        }
    }

    public static Profile getFMIProfile(EObject context) {
        return UMLUtil.getProfile((EPackage)FMIProfilePackage.eINSTANCE, (EObject)context);
    }

    public static Stereotype getStereotype(EObject context, String shortName) {
        Profile fmiProfile = FMIProfileUtil.getFMIProfile(context);
        if (fmiProfile != null) {
            return fmiProfile.getOwnedStereotype(shortName);
        }
        return null;
    }

    public static Fmi2ScalarVariable getFMIVariable(Property base_Property) {
        FmiModelDescriptionType modelDesc;
        FMU owningFMU;
        Class owningClass;
        if (base_Property != null && base_Property.getName() != null && (owningClass = base_Property.getClass_()) != null && (owningFMU = FastUMLUtil.fastGetStereotypeApplication((Element)owningClass, FMU.class)) != null && (modelDesc = owningFMU.getModelDescription()) != null && modelDesc.getModelVariables() != null) {
            for (Fmi2ScalarVariable variable : modelDesc.getModelVariables().getScalarVariable()) {
                if (!base_Property.getName().equals(variable.getName())) continue;
                return variable;
            }
        }
        return null;
    }

    public static Boolean isFMUPort(StructuralFeature p) {
        if (FastUMLUtil.fastGetStereotypeApplication((Element)p, Port.class) != null) {
            return true;
        }
        return false;
    }

    public static Boolean isCS_FMU(Class c) {
        if (FastUMLUtil.fastGetStereotypeApplication((Element)c, CS_FMU.class) != null) {
            return true;
        }
        return false;
    }

    public static Boolean isME_FMU(Class c) {
        if (FastUMLUtil.fastGetStereotypeApplication((Element)c, ME_FMU.class) != null) {
            return true;
        }
        return false;
    }

    public static Boolean isFMU(Class c) {
        if (!FMIProfileUtil.isME_FMU(c).booleanValue() && !FMIProfileUtil.isCS_FMU(c).booleanValue()) {
            return false;
        }
        return true;
    }

    public static int getValueReference(Property fmuPort) {
        Port fmiPortObj = FastUMLUtil.fastGetStereotypeApplication((Element)fmuPort, Port.class);
        if (fmiPortObj != null) {
            return fmiPortObj.getValueReference();
        }
        return -1;
    }

    public static boolean isOutputPort(Property p) {
        return p instanceof org.eclipse.uml2.uml.Port && FlowDirection.OUT == FMIProfileUtil.getDirection((org.eclipse.uml2.uml.Port)p);
    }

    public static boolean isInputPort(Property p) {
        return p instanceof org.eclipse.uml2.uml.Port && FlowDirection.IN == FMIProfileUtil.getDirection((org.eclipse.uml2.uml.Port)p);
    }

    public static FlowDirection getDirection(org.eclipse.uml2.uml.Port port) {
        Port fmiPortObj = FastUMLUtil.fastGetStereotypeApplication((Element)port, Port.class);
        if (fmiPortObj != null) {
            return fmiPortObj.getDirection();
        }
        return null;
    }

    public static int computeNewValueReference(Property prop) {
        Class owningClass = prop.getClass_();
        ArrayList<Integer> valueReferences = new ArrayList<Integer>();
        for (Property attr : owningClass.getAllAttributes()) {
            if (attr == prop) continue;
            valueReferences.add(FMIProfileUtil.getValueReference(attr));
        }
        if (!valueReferences.isEmpty()) {
            return (Integer)Collections.max(valueReferences) + 1;
        }
        return 0;
    }

    public static CS_FMU getCSFMU(Class umlClass) {
        return FastUMLUtil.fastGetStereotypeApplication((Element)umlClass, CS_FMU.class);
    }

    public static List<ScalarVariable> collectScalarVariables(Class umlClass) {
        ArrayList<ScalarVariable> result = new ArrayList<ScalarVariable>();
        for (Property prop : umlClass.getAllAttributes()) {
            ScalarVariable variable = FastUMLUtil.fastGetStereotypeApplication((Element)prop, ScalarVariable.class);
            if (variable == null) continue;
            result.add(variable);
        }
        return result;
    }
}

