/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.fmiprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CausalityKind implements Enumerator
{
    PARAMETER(0, "parameter", "parameter"),
    CALCULATED_PARAMETER(1, "calculatedParameter", "calculatedParameter"),
    INPUT(2, "input", "input"),
    OUTPUT(3, "output", "output"),
    LOCAL(4, "local", "local"),
    INDEPENDENT(5, "independent", "independent");

    public static final int PARAMETER_VALUE = 0;
    public static final int CALCULATED_PARAMETER_VALUE = 1;
    public static final int INPUT_VALUE = 2;
    public static final int OUTPUT_VALUE = 3;
    public static final int LOCAL_VALUE = 4;
    public static final int INDEPENDENT_VALUE = 5;
    private static final CausalityKind[] VALUES_ARRAY;
    public static final List<CausalityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CausalityKind[]{PARAMETER, CALCULATED_PARAMETER, INPUT, OUTPUT, LOCAL, INDEPENDENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CausalityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CausalityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CausalityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CausalityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CausalityKind get(int value) {
        switch (value) {
            case 0: {
                return PARAMETER;
            }
            case 1: {
                return CALCULATED_PARAMETER;
            }
            case 2: {
                return INPUT;
            }
            case 3: {
                return OUTPUT;
            }
            case 4: {
                return LOCAL;
            }
            case 5: {
                return INDEPENDENT;
            }
        }
        return null;
    }

    private CausalityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

