/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.common.writing;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.papyrus.moka.xygraph.common.writing.ResourceBaseUpdateStrategy;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphMappingHelper;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphWidgetBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.XYGraphUpdateStrategy;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphPackage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;

public class ResourceXYGraphUpdateStrategy
extends ResourceBaseUpdateStrategy
implements XYGraphUpdateStrategy {
    public void updateXYGraph(XYGraph xy, XYGraphWidgetBinder map) {
        XYGraphDescriptor gDesc = map.getXYGraphDescriptor();
        TransactionalEditingDomain domain = this.getTransactionalEditingDomain(map.getXYGraphDescriptor().eResource());
        CompoundCommand cc = new CompoundCommand();
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_Title(), xy.getTitle());
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_TitleColor(), XYGraphMappingHelper.mapColor((Color)xy.getTitleColor()));
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_TitleFont(), XYGraphMappingHelper.mapFontData((FontData)xy.getTitleFontData()));
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_ZoomType(), XYGraphMappingHelper.mapZoomType((ZoomType)xy.getZoomType()));
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_ShowLegend(), xy.isShowLegend());
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_ShowTitle(), xy.isShowTitle());
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_Transparent(), xy.isTransparent());
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_ShowPlotAreaBorder(), xy.getPlotArea().isShowBorder());
        this.appendSetCommand(cc, (EditingDomain)domain, (EObject)gDesc, (EStructuralFeature)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_PlotAreaBackgroundColor(), XYGraphMappingHelper.mapColor((Color)xy.getPlotArea().getBackgroundColor()));
        if (cc.canExecute()) {
            domain.getCommandStack().execute((Command)cc);
        }
    }

    public void addTrace(XYGraphDescriptor gDesc, TraceDescriptor trace) {
        TransactionalEditingDomain domain = this.getTransactionalEditingDomain(gDesc.eResource());
        CompoundCommand cc = new CompoundCommand();
        cc.append(AddCommand.create((EditingDomain)domain, (Object)gDesc, (Object)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_TraceDescriptors(), (Object)trace));
        if (cc.canExecute()) {
            domain.getCommandStack().execute((Command)cc);
        }
    }

    public void setTraceVisibility(XYGraphDescriptor gDesc, TraceDescriptor tDesc, boolean visible) {
        TransactionalEditingDomain domain = this.getTransactionalEditingDomain(gDesc.eResource());
        CompoundCommand cc = new CompoundCommand();
        if (visible) {
            cc.append(AddCommand.create((EditingDomain)domain, (Object)gDesc, (Object)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_VisibleTraces(), (Object)tDesc));
        } else {
            cc.append(RemoveCommand.create((EditingDomain)domain, (Object)gDesc, (Object)XYGraphPackage.eINSTANCE.getXYGraphDescriptor_VisibleTraces(), (Object)tDesc));
        }
        if (cc.canExecute()) {
            domain.getCommandStack().execute((Command)cc);
        }
    }
}

