/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.common.ui;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;

public class XYGraphEditorPartSelectionProvider
implements ISelectionProvider {
    private final ListenerList<ISelectionChangedListener> fListeners = new ListenerList();
    private ISelection currentSelection = StructuredSelection.EMPTY;

    public XYGraphEditorPartSelectionProvider(XYGraphDescriptor xyGraphDescriptor) {
        this.currentSelection = new StructuredSelection((Object)xyGraphDescriptor);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.currentSelection != null && this.currentSelection.equals(selection)) {
            return;
        }
        this.currentSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        for (ISelectionChangedListener current : this.fListeners) {
            current.selectionChanged(event);
        }
    }
}

