/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.utils.helper.semantics;

import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IPseudostateActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateMachineSemanticVisitor;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.ITransitionActivation;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.NamedElement;

public class SemanticHelper {
    public static NamedElement getModelElement(ISemanticVisitor visitor) {
        ActivityNode modelElement = null;
        if (visitor instanceof IActivityNodeActivation) {
            modelElement = ((IActivityNodeActivation)visitor).getNode();
        } else if (visitor instanceof IActivityEdgeInstance) {
            modelElement = ((IActivityEdgeInstance)visitor).getEdge();
        } else if (visitor instanceof IStateMachineSemanticVisitor) {
            modelElement = ((IStateMachineSemanticVisitor)visitor).getNode();
        }
        return modelElement;
    }

    public static String getName(ISemanticVisitor visitor) {
        String name = "undefined";
        NamedElement modelElement = SemanticHelper.getModelElement(visitor);
        if (modelElement != null) {
            if (modelElement.getName() != null) {
                name = modelElement.getName();
            }
            if (visitor instanceof IActivityNodeActivation) {
                name = String.valueOf(name) + " [Activity Node]";
            } else if (visitor instanceof IActivityEdgeInstance) {
                name = String.valueOf(name) + " [Activity Edge]";
            } else if (visitor instanceof IPseudostateActivation) {
                name = String.valueOf(name) + " [Pseudostate]";
            } else if (visitor instanceof IStateActivation) {
                name = String.valueOf(name) + " [State]";
            } else if (visitor instanceof ITransitionActivation) {
                name = String.valueOf(name) + " [Transition]";
            }
        }
        return name;
    }
}

