/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.dnd.strategy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.moka.simex.dnd.command.CreateAndDropGenericCommand;
import org.eclipse.papyrus.moka.simex.dnd.strategy.DndMessages;
import org.eclipse.papyrus.moka.simex.utils.RequestUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class AbstractDropInActivityStrategy
extends TransactionalDropStrategy {
    public static final String SIMEX_DROP_STRATEGY_PREFIX = "org.eclipse.papyrus.moka.simex.";
    protected EClass droppedObjectEClass;
    protected EClass eObjectToCreateType;
    protected EReference referenceToSet;
    protected IElementType elementTypeToCreate;
    protected String namePrefix = null;
    protected String nameSuffix = null;

    protected AbstractDropInActivityStrategy(EClass droppedObjectEClass, EClass eObjectToCreateType, EReference referenceToSet) {
        this.droppedObjectEClass = droppedObjectEClass;
        this.eObjectToCreateType = eObjectToCreateType;
        this.referenceToSet = referenceToSet;
        this.elementTypeToCreate = null;
    }

    protected AbstractDropInActivityStrategy(EClass droppedObjectEClass, IElementType elementTypeCreateType, EReference referenceToSet) {
        this.droppedObjectEClass = droppedObjectEClass;
        this.eObjectToCreateType = null;
        this.referenceToSet = referenceToSet;
        this.elementTypeToCreate = elementTypeCreateType;
    }

    public String getLabel() {
        String targetTypeName = this.getEClassToCreate().getName();
        Object[] bindings = new Object[]{this.droppedObjectEClass.getName(), targetTypeName};
        return NLS.bind((String)DndMessages.AbstractDropStrategy_Label, (Object[])bindings);
    }

    public String getDescription() {
        if (this.referenceToSet != null) {
            Object[] bindings = new Object[]{this.droppedObjectEClass.getName(), this.getEClassToCreate().getName(), this.referenceToSet.getName()};
            return NLS.bind((String)DndMessages.AbstractDropStrategy_Description, (Object[])bindings);
        }
        Object[] bindings = new Object[]{this.droppedObjectEClass.getName(), this.getEClassToCreate().getName()};
        return NLS.bind((String)DndMessages.AbstractDropStrategy_Description_No_Ref, (Object[])bindings);
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return SIMEX_DROP_STRATEGY_PREFIX + this.droppedObjectEClass.getName() + "." + this.getEClassToCreate().getName();
    }

    private EClass getEClassToCreate() {
        return this.eObjectToCreateType != null ? this.eObjectToCreateType : this.elementTypeToCreate.getEClass();
    }

    public int getPriority() {
        return 0;
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        EObject targetElement;
        if (!(request instanceof DropObjectsRequest)) {
            return null;
        }
        DropObjectsRequest dropReq = (DropObjectsRequest)request;
        List<EObject> handledDroppedObjects = this.getHandledDroppedObjects((Request)dropReq);
        if (!this.canHandleRequest(handledDroppedObjects, targetElement = this.getTargetSemanticElement(targetEditPart))) {
            return null;
        }
        if (targetElement.eClass() == this.getEClassToCreate()) {
            return RequestUtils.getSetFeatureCommand(targetElement, handledDroppedObjects.get(0), (EStructuralFeature)this.referenceToSet);
        }
        Activity targetActivity = this.getTargetActivity(targetElement);
        Point location = dropReq.getLocation();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (EObject droppedObject : handledDroppedObjects) {
            compoundCommand.add(this.getCreateAndDropObjectCommand(droppedObject, targetActivity, location, (GraphicalEditPart)targetEditPart));
            location.performTranslate(5, 5);
        }
        return compoundCommand;
    }

    protected Command getCreateAndDropObjectCommand(EObject droppedObject, Activity targetActivity, Point location, GraphicalEditPart targetEditPart) {
        CreateAndDropGenericCommand command = this.eObjectToCreateType != null ? new CreateAndDropGenericCommand(targetActivity, this.eObjectToCreateType, this.referenceToSet, droppedObject, location, targetEditPart) : new CreateAndDropGenericCommand(targetActivity, this.elementTypeToCreate, this.referenceToSet, droppedObject, location, targetEditPart);
        command.setPrefix(this.namePrefix);
        command.setSuffix(this.nameSuffix);
        return new ICommandProxy((ICommand)command);
    }

    private Activity getTargetActivity(EObject targetElement) {
        if (targetElement instanceof Activity) {
            return (Activity)targetElement;
        }
        if (targetElement instanceof ActivityGroup) {
            return ((ActivityGroup)targetElement).containingActivity();
        }
        return null;
    }

    protected List<EObject> getHandledDroppedObjects(Request req) {
        List droppedObjects = this.getSourceEObjects(req);
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (droppedObjects != null) {
            for (EObject droppedObject : droppedObjects) {
                if (droppedObject.eClass() != this.droppedObjectEClass && !droppedObject.eClass().getEAllSuperTypes().contains((Object)this.droppedObjectEClass)) continue;
                result.add(droppedObject);
            }
        }
        return result;
    }

    protected boolean canHandleRequest(List<EObject> droppedObjects, EObject targetElement) {
        boolean result = false;
        if (!droppedObjects.isEmpty()) {
            result = targetElement instanceof Activity || targetElement instanceof StructuredActivityNode && !(targetElement instanceof LoopNode) || targetElement.eClass() == this.getEClassToCreate() && droppedObjects.size() == 1;
        }
        return result;
    }

    public void setNamePrefix(String prefix) {
        this.namePrefix = prefix;
    }

    public void setNameSuffix(String suffix) {
        this.nameSuffix = suffix;
    }
}

