/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.advices;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.moka.simex.utils.EventUtil;
import org.eclipse.papyrus.moka.simex.utils.RequestUtils;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.UMLPackage;

public class SignalEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        if (request.getElementToConfigure() instanceof Signal) {
            final Signal signal = (Signal)request.getElementToConfigure();
            return new ConfigureElementCommand(request){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    EventUtil.getSignalEvent(signal);
                    return CommandResult.newOKCommandResult((Object)signal);
                }
            };
        }
        return super.getAfterConfigureCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(request.getFeature())) {
            final Signal signal = (Signal)request.getElementToEdit();
            return new EditElementCommand("Update Signal Name", (EObject)signal, (IEditCommandRequest)request){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    EventUtil.alignEventName(signal);
                    return CommandResult.newOKCommandResult((Object)signal);
                }
            };
        }
        return super.getBeforeSetCommand(request);
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        Signal signal;
        SignalEvent event;
        if (request.getElementToDestroy() instanceof Signal && (event = EventUtil.getSignalEvent(signal = (Signal)request.getElementToDestroy(), false)) != null) {
            AbstractTransactionalCommand ret = new AbstractTransactionalCommand(request.getEditingDomain(), "Destroy depending signal events", Collections.EMPTY_LIST){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    RequestUtils.deleteObjectWithRequest((EObject)event);
                    return CommandResult.newOKCommandResult();
                }
            };
            return ret;
        }
        return super.getBeforeDestroyDependentsCommand(request);
    }
}

