/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.variables;

import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapterFactory;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueList;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.MokaVariableAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IToken;

public class TokensVariableAdapter
extends MokaVariableAdapter {
    protected List<IToken> heldTokens;
    private final String NAME = "tokens";
    private final String REFERENCE_TYPE_NAME = "List<IToken>";

    public TokensVariableAdapter(MokaDebugTarget debugTarget, List<IToken> tokens) {
        super(debugTarget);
        this.heldTokens = tokens;
    }

    public IValue getValue() throws DebugException {
        if (this.value == null) {
            MokaValueList tokensList = new MokaValueList(this.debugTarget);
            Iterator<IToken> tokensIterator = this.heldTokens.iterator();
            while (tokensIterator.hasNext()) {
                tokensList.add(MokaValueAdapterFactory.getInstance().instantiate(tokensIterator.next(), this.debugTarget));
            }
            this.value = tokensList;
        }
        return this.value;
    }

    public String getName() throws DebugException {
        return "tokens";
    }

    public String getReferenceTypeName() throws DebugException {
        return "List<IToken>";
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }
}

