/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.papyrus.moka.debug.engine.IMokaThread;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugElement;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.ExecutionContextVariableAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.SuspensionPointVariableAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.utils.helper.semantics.SemanticHelper;

public class MokaStackFrame
extends MokaDebugElement
implements IStackFrame {
    protected IMokaThread owner;
    protected List<IVariable> variables;

    public MokaStackFrame(MokaDebugTarget debugTarget, IMokaThread thread) {
        super(debugTarget);
        this.owner = thread;
        this.variables = new ArrayList<IVariable>();
    }

    public boolean canStepInto() {
        return this.owner.canStepInto();
    }

    public boolean canStepOver() {
        return this.owner.canStepOver();
    }

    public boolean canStepReturn() {
        return this.owner.canStepReturn();
    }

    public boolean isStepping() {
        return this.owner.isStepping();
    }

    public void stepInto() throws DebugException {
        this.owner.stepInto();
    }

    public void stepOver() throws DebugException {
        this.owner.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.owner.stepReturn();
    }

    public boolean canResume() {
        return this.owner.canResume();
    }

    public boolean canSuspend() {
        return this.owner.canSuspend();
    }

    public boolean isSuspended() {
        return this.owner.isSuspended();
    }

    public void resume() throws DebugException {
        this.owner.resume();
    }

    public void suspend() throws DebugException {
        this.owner.suspend();
    }

    public boolean canTerminate() {
        return this.owner.canTerminate();
    }

    public boolean isTerminated() {
        return this.owner.isTerminated();
    }

    public void terminate() throws DebugException {
        this.owner.terminate();
    }

    public IThread getThread() {
        return this.owner;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.variables.isEmpty()) {
            this.variables.add(new ExecutionContextVariableAdapter(this.debugTarget, this.owner.getLogicalThread()));
            ISemanticVisitor visitor = this.owner.getSuspensionPoint();
            if (visitor != null) {
                this.variables.add(new SuspensionPointVariableAdapter(this.debugTarget, visitor));
            }
        }
        return this.variables.toArray(new IVariable[0]);
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public int getLineNumber() throws DebugException {
        return 0;
    }

    public int getCharStart() throws DebugException {
        return 0;
    }

    public int getCharEnd() throws DebugException {
        return 0;
    }

    public String getName() throws DebugException {
        return SemanticHelper.getName((ISemanticVisitor)this.owner.getSuspensionPoint());
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }
}

