/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.timedfuml.semantics;

import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.discreteevent.Event;
import org.eclipse.papyrus.moka.discreteevent.actions.Action;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IRealValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.BasicActions.ActionActivation;
import org.eclipse.papyrus.moka.timedfuml.actions._sendAcceptEventOfferAction;
import org.eclipse.papyrus.moka.timedfuml.semantics.OpaqueExpressionEvaluationWithContext;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Trigger;

public class Timed_AcceptEventActionActivation
extends ActionActivation {
    public void sendOffers() {
        double relativeDate = 0.0;
        double absoluteDate = 0.0;
        double currentTime = 0.0;
        for (Element elt : ((org.eclipse.uml2.uml.Action)this.node).getOwnedElements()) {
            boolean isMissed = false;
            Trigger t = (Trigger)elt;
            TimeEvent e = (TimeEvent)t.getEvent();
            TimeExpression texp = e.getWhen();
            Object evaluation = null;
            if (texp.getExpr() instanceof OpaqueExpression) {
                OpaqueExpressionEvaluationWithContext opaqueEvaluation = new OpaqueExpressionEvaluationWithContext();
                opaqueEvaluation.specification = texp.getExpr();
                opaqueEvaluation.locus = this.getExecutionLocus();
                opaqueEvaluation.context = this.getExecutionContext();
                evaluation = opaqueEvaluation;
            } else {
                evaluation = this.getExecutionLocus().getFactory().createEvaluation(texp.getExpr());
            }
            if (e.isRelative()) {
                relativeDate = ((IRealValue)evaluation.evaluate()).getValue();
            } else {
                absoluteDate = ((IRealValue)evaluation.evaluate()).getValue();
                if (absoluteDate < (currentTime = DEScheduler.getInstance().getCurrentTime())) {
                    isMissed = true;
                    System.out.println("Time Event is missed, absoluteTime = " + absoluteDate + " > currentTime = " + currentTime);
                } else {
                    relativeDate = absoluteDate - currentTime;
                }
            }
            if (isMissed) continue;
            _sendAcceptEventOfferAction sendOfferAction = new _sendAcceptEventOfferAction(this);
            this.suspend();
            DEScheduler.getInstance().pushEvent(new Event(relativeDate, (Action)sendOfferAction));
        }
    }

    public void sendOffersDefault() {
        this.resume();
        super.sendOffers();
    }

    public void doAction() {
    }
}

