/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.viewpoint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.papyrus.infra.architecture.listeners.IArchitectureDescriptionListener;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.DropStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;

public class SimexViewpointListener
implements IArchitectureDescriptionListener {
    private static final String SIMEX_ARCHITECTURE_FRAMEWORK = "Simex";
    protected boolean isActive = false;
    private List<DropStrategy> dropStrategiesToRestore = new ArrayList<DropStrategy>();

    public SimexViewpointListener() {
        this.init();
    }

    private void init() {
        for (DropStrategy strategy : DropStrategyManager.instance.getAllStrategies()) {
            if (this.shouldBeActivated(strategy)) continue;
            this.dropStrategiesToRestore.add(strategy);
        }
        this.configureDndStrategies();
    }

    public void architectureContextChanged(Notification notification) {
        String architectureContext = notification.getNewStringValue();
        if (architectureContext.equals(SIMEX_ARCHITECTURE_FRAMEWORK)) {
            if (!this.isActive) {
                this.configureDndStrategies();
                this.isActive = true;
            }
        } else {
            this.restoreDndStrategies();
            this.isActive = false;
        }
    }

    public void architectureViewpointsChanged(Notification notification) {
    }

    protected void restoreDndStrategies() {
        if (this.dropStrategiesToRestore != null) {
            for (DropStrategy strategy : DropStrategyManager.instance.getAllStrategies()) {
                if (this.dropStrategiesToRestore.contains(strategy)) {
                    DropStrategyManager.instance.setActive(strategy, true);
                    continue;
                }
                DropStrategyManager.instance.setActive(strategy, false);
            }
        }
    }

    protected void configureDndStrategies() {
        if (this.dropStrategiesToRestore != null) {
            for (DropStrategy strategy : DropStrategyManager.instance.getAllStrategies()) {
                if (!this.dropStrategiesToRestore.contains(strategy)) {
                    DropStrategyManager.instance.setActive(strategy, true);
                    continue;
                }
                DropStrategyManager.instance.setActive(strategy, false);
            }
        }
    }

    protected boolean shouldBeActivated(DropStrategy strategy) {
        return strategy.getID().startsWith("org.eclipse.papyrus.moka.simex.");
    }
}

