/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.advices.commands;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.moka.simex.advices.commands.AbstractPinUpdateCommand;
import org.eclipse.papyrus.moka.simex.utils.PinUtils;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.AddStructuralFeatureValueAction;
import org.eclipse.uml2.uml.BroadcastSignalAction;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.ClearAssociationAction;
import org.eclipse.uml2.uml.ClearStructuralFeatureAction;
import org.eclipse.uml2.uml.CreateObjectAction;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.ReadExtentAction;
import org.eclipse.uml2.uml.ReadStructuralFeatureAction;
import org.eclipse.uml2.uml.ReduceAction;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UnmarshallAction;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class PinUpdateICommandFactory
extends UMLSwitch<ICommand> {
    private EObject objectToEdit;
    private EStructuralFeature updatedFeature;

    public ICommand caseCallOperationAction(final CallOperationAction object) {
        if (this.updatedFeature.getFeatureID() == 32 || this.updatedFeature.getFeatureID() == 29) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + object.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateCallOperationActionPins(object);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseCallBehaviorAction(final CallBehaviorAction object) {
        if (this.updatedFeature.getFeatureID() == 32) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + object.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateCallBehaviorActionPins(object);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseSendSignalAction(final SendSignalAction object) {
        if (this.updatedFeature.getFeatureID() == 30 || this.updatedFeature.getFeatureID() == 29) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + object.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateSendSignalActionPins(object);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseBroadcastSignalAction(final BroadcastSignalAction object) {
        if (this.updatedFeature.getFeatureID() == 30) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + object.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateBroadcastSignalActionPins(object);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseAcceptEventAction(AcceptEventAction object) {
        if (this.updatedFeature.getFeatureID() == 30 || this.updatedFeature.getFeatureID() == 28) {
            return this.getUpdateAcceptEventUpdateCommand(object);
        }
        return null;
    }

    public ICommand caseAcceptCallAction(AcceptCallAction acceptAction) {
        if (this.updatedFeature.getFeatureID() == 30) {
            return this.getUpdateAcceptCallActionUpdateCommand(acceptAction);
        }
        return null;
    }

    public ICommand caseSignalEvent(SignalEvent signalEvent) {
        if (this.updatedFeature.getFeatureID() == 12) {
            Set<Action> actionsToUpdate = this.findReferencingAcceptActions((Event)signalEvent);
            CompositeCommand cc = new CompositeCommand("update accept signal actions");
            for (Action actionToUpdate : actionsToUpdate) {
                if (!(actionToUpdate instanceof AcceptEventAction)) continue;
                cc.add((IUndoableOperation)this.getUpdateAcceptEventUpdateCommand((AcceptEventAction)actionToUpdate));
            }
            return cc;
        }
        return null;
    }

    public ICommand caseCallEvent(CallEvent callEvent) {
        if (this.updatedFeature.getFeatureID() == 12) {
            Set<Action> actionsToUpdate = this.findReferencingAcceptActions((Event)callEvent);
            CompositeCommand cc = new CompositeCommand("update accept call event actions");
            for (Action actionToUpdate : actionsToUpdate) {
                if (!(actionToUpdate instanceof AcceptCallAction)) continue;
                cc.add((IUndoableOperation)this.getUpdateAcceptCallActionUpdateCommand((AcceptCallAction)actionToUpdate));
            }
            return cc;
        }
        return null;
    }

    public ICommand caseTrigger(Trigger trigger) {
        if (this.updatedFeature.getFeatureID() == 10) {
            if (trigger.getOwner() instanceof AcceptCallAction) {
                AcceptCallAction action = (AcceptCallAction)trigger.getOwner();
                return this.getUpdateAcceptCallActionUpdateCommand(action);
            }
            if (trigger.getOwner() instanceof AcceptEventAction) {
                AcceptEventAction action = (AcceptEventAction)trigger.getOwner();
                return this.getUpdateAcceptEventUpdateCommand(action);
            }
        }
        return null;
    }

    public ICommand caseReadStructuralFeatureAction(final ReadStructuralFeatureAction readAction) {
        if (this.updatedFeature.getFeatureID() == 29) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + readAction.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateReadStructuralFeatureActionPins(readAction);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseAddStructuralFeatureValueAction(final AddStructuralFeatureValueAction addAction) {
        if (this.updatedFeature.getFeatureID() == 29) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + addAction.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateAddStructuralFeatureActionPins(addAction);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseClearStructuralFeatureAction(final ClearStructuralFeatureAction clearAction) {
        if (this.updatedFeature.getFeatureID() == 29) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + clearAction.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateClearStructuralFeatureActionPins(clearAction);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseUnmarshallAction(final UnmarshallAction action) {
        if (this.updatedFeature.getFeatureID() == 30) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + action.getName() + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateUnmarshallActionPins(action);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseReadExtentAction(final ReadExtentAction action) {
        if (this.updatedFeature.getFeatureID() == 28) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + action + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateReadExtentActionPins(action);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseCreateObjectAction(final CreateObjectAction action) {
        if (this.updatedFeature.getFeatureID() == 28) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + action + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateCreateObjectActionPins(action);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseReduceAction(final ReduceAction action) {
        if (this.updatedFeature.getFeatureID() == 30) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + action + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateReduceActionPins(action);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    public ICommand caseClearAssociationAction(final ClearAssociationAction action) {
        if (this.updatedFeature.getFeatureID() == 28) {
            AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + action + " pins"){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    PinUtils.updateClearAssocationActionPins(action);
                    return CommandResult.newOKCommandResult();
                }
            };
            return command;
        }
        return null;
    }

    private Set<Action> findReferencingAcceptActions(Event event) {
        HashSet<Action> referencingActions = new HashSet<Action>();
        CrossReferenceAdapter refAdapter = CrossReferencerUtil.getCrossReferenceAdapter((EObject)event);
        Set triggers = refAdapter.getInverseReferencers((EObject)event, UMLPackage.eINSTANCE.getTrigger_Event(), UMLPackage.eINSTANCE.getTrigger());
        for (Trigger trigger : triggers) {
            if (!(trigger.getOwner() instanceof Action)) continue;
            referencingActions.add((Action)((AcceptEventAction)trigger.getOwner()));
        }
        return referencingActions;
    }

    private ICommand getUpdateAcceptCallActionUpdateCommand(final AcceptCallAction acceptAction) {
        AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + acceptAction.getName() + " pins"){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                PinUtils.updateAcceptCallActionPins(acceptAction);
                return CommandResult.newOKCommandResult();
            }
        };
        return command;
    }

    private ICommand getUpdateAcceptEventUpdateCommand(final AcceptEventAction actionToUpdate) {
        AbstractPinUpdateCommand command = new AbstractPinUpdateCommand("update " + actionToUpdate.getName() + " pins"){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                PinUtils.updateAcceptEventActionPins(actionToUpdate);
                return CommandResult.newOKCommandResult();
            }
        };
        return command;
    }

    public ICommand getCommand(IEditCommandRequest request) {
        if (request instanceof SetRequest) {
            SetRequest setReq = (SetRequest)request;
            this.objectToEdit = setReq.getElementToEdit();
            this.updatedFeature = setReq.getFeature();
            if (this.updatedFeature != null) {
                return (ICommand)this.doSwitch(this.objectToEdit);
            }
        }
        return null;
    }
}

