/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine;

import java.util.List;
import java.util.Set;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.moka.animation.engine.animators.Animator;
import org.eclipse.papyrus.moka.animation.engine.animators.AnimatorExtensionEvaluator;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationEngine;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.animation.engine.rendering.DiagramHandler;
import org.eclipse.papyrus.moka.animation.engine.rendering.IAnimation;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.service.AbstractMokaService;
import org.eclipse.papyrus.moka.service.IMokaExecutionListener;

public class AnimationService
extends AbstractMokaService
implements IAnimation,
IMokaExecutionListener {
    protected AnimationEngine engine = new AnimationEngine();
    protected List<Animator> animators = AnimatorExtensionEvaluator.evaluateAnimators(this.engine);

    public void init(ILaunch launcher, EObject modelElement) {
        this.engine.init(modelElement);
    }

    public Animator getAnimator(ISemanticVisitor nodeVisitor) {
        Animator animator = null;
        for (Animator current : this.animators) {
            if (!current.accept(nodeVisitor)) continue;
            animator = animator != null ? (current.getPriority() > animator.getPriority() ? current : animator) : current;
        }
        return animator;
    }

    public void nodeVisited(ISemanticVisitor nodeVisitor) {
        Animator animator = this.getAnimator(nodeVisitor);
        if (animator != null) {
            animator.nodeVisited(nodeVisitor);
        }
    }

    public void nodeLeft(ISemanticVisitor nodeVisitor) {
        Animator animator = this.getAnimator(nodeVisitor);
        if (animator != null) {
            animator.nodeLeft(nodeVisitor);
        }
    }

    public void valueCreated(IValue value) {
        DiagramHandler diagramHandler;
        if (value instanceof IObject_ && !(diagramHandler = this.engine.getDiagramHandler()).isRegistered((IObject_)value)) {
            Set<Diagram> relatedDiagrams = diagramHandler.findDiagramsInvolved((IObject_)value);
            for (Diagram diagram : relatedDiagrams) {
                diagramHandler.addRenderable((IObject_)value, diagram);
            }
        }
    }

    public void valueDestroyed(IValue value) {
        if (value instanceof IObject_) {
            this.engine.getDiagramHandler().deleteRenderable((IObject_)value);
        }
    }

    public void dispose() {
        this.engine.clean();
    }

    @Override
    public void renderAs(EObject modelElement, IObject_ animator, AnimationKind targetStyle) {
        this.engine.removeRenderingRules(modelElement);
        this.engine.startRendering(modelElement, animator, targetStyle);
    }

    @Override
    public void renderAs(EObject modelElement, IObject_ animator, AnimationKind sourceStyle, AnimationKind targetStyle, int duration) {
        this.engine.removeRenderingRules(modelElement);
        this.engine.startRendering(modelElement, animator, sourceStyle);
        if (duration >= 25) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.engine.stopRendering(modelElement, animator, sourceStyle);
        this.engine.startRendering(modelElement, animator, targetStyle);
    }
}

