/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.validation.constraints;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Signal;

public class ArgumentAndResultPinsOfCallActions_Constraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Signal s;
        ArrayList<Parameter> inputParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> outputParameters = new ArrayList<Parameter>();
        if (ctx.getTarget() instanceof CallOperationAction || ctx.getTarget() instanceof CallBehaviorAction) {
            Behavior behav;
            ArrayList allParameters = new ArrayList();
            if (ctx.getTarget() instanceof CallOperationAction) {
                Operation op = ((CallOperationAction)ctx.getTarget()).getOperation();
                if (op != null) {
                    allParameters.addAll(op.getOwnedParameters());
                }
            } else if (ctx.getTarget() instanceof CallBehaviorAction && (behav = ((CallBehaviorAction)ctx.getTarget()).getBehavior()) != null) {
                allParameters.addAll(behav.getOwnedParameters());
            }
            for (Parameter p : allParameters) {
                if (p.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL) || p.getDirection().equals((Object)ParameterDirectionKind.INOUT_LITERAL)) {
                    inputParameters.add(p);
                }
                if (!p.getDirection().equals((Object)ParameterDirectionKind.INOUT_LITERAL) && !p.getDirection().equals((Object)ParameterDirectionKind.OUT_LITERAL) && !p.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
                outputParameters.add(p);
            }
        } else if (ctx.getTarget() instanceof SendSignalAction && (s = ((SendSignalAction)ctx.getTarget()).getSignal()) != null) {
            inputParameters.addAll((Collection<Parameter>)s.getAllAttributes());
        }
        CallAction callAction = (CallAction)ctx.getTarget();
        String argumentsErrorMessage = "";
        if (callAction.getArguments().size() < inputParameters.size()) {
            argumentsErrorMessage = String.valueOf(argumentsErrorMessage) + "Not enough argument pins (found " + callAction.getArguments().size() + ", expected " + inputParameters.size() + ")";
        } else if (callAction.getArguments().size() > inputParameters.size()) {
            argumentsErrorMessage = String.valueOf(argumentsErrorMessage) + "Too many argument pins (found " + callAction.getArguments().size() + ", expected " + inputParameters.size() + ")";
        }
        String resultsErrorMessage = "";
        if (callAction.getResults().size() < outputParameters.size()) {
            resultsErrorMessage = String.valueOf(resultsErrorMessage) + "Not enough result pins (found " + callAction.getResults().size() + ", expected " + outputParameters.size() + ")";
        } else if (callAction.getResults().size() > outputParameters.size() && callAction.getResults().size() < outputParameters.size()) {
            resultsErrorMessage = String.valueOf(resultsErrorMessage) + "Too many result pins (found " + callAction.getResults().size() + ", expected " + outputParameters.size() + ")";
        }
        if (argumentsErrorMessage.equals("") && resultsErrorMessage.equals("")) {
            return ctx.createSuccessStatus();
        }
        if (!argumentsErrorMessage.equals("")) {
            resultsErrorMessage = " - " + resultsErrorMessage;
        }
        return ctx.createFailureStatus(new Object[]{String.valueOf(argumentsErrorMessage) + resultsErrorMessage});
    }
}

