/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.values;

import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.InvocationActions.ICS_EventOccurrence;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_InteractionPoint;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ActionActivationValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ActivityEdgeInstanceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.CS_EventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.CS_InteractionPointValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.CallEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.CompletionEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.DefaultValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ObjectNodeActivationValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ObjectTokenValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ObjectValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.PrimitiveValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ReferenceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.SignalEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.StructuredValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.TimeEventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.TokenValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.TriggeredVisitorValueAdapter;
import org.eclipse.papyrus.moka.fuml.Profiling.ITriggeredVisitorWrapper;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.IActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.CompleteActions.IAcceptEventActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IForkedToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IObjectNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IObjectToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IPrimitiveValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IStructuredValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.ICallEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.ISignalEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.ICompletionEventOccurrence;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.ITransitionActivation;
import org.eclipse.papyrus.moka.timedfuml.interfaces.semantics.CommonBehaviors.ITimedEventOccurrence;

public class MokaValueAdapterFactory {
    protected static MokaValueAdapterFactory INSTANCE;

    private MokaValueAdapterFactory() {
    }

    public static MokaValueAdapterFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MokaValueAdapterFactory();
        }
        return INSTANCE;
    }

    public MokaValueAdapter<?> instantiate(Object value, MokaDebugTarget debugTarget) {
        MokaValueAdapter adapter = null;
        if (value != null) {
            if (value instanceof IEventOccurrence) {
                if (value instanceof ICS_EventOccurrence) {
                    adapter = new CS_EventOccurrenceValueAdapter(debugTarget, (IEventOccurrence)((ICS_EventOccurrence)value));
                } else if (value instanceof ITimedEventOccurrence) {
                    adapter = new TimeEventOccurrenceValueAdapter(debugTarget, (IEventOccurrence)((ITimedEventOccurrence)value));
                } else if (value instanceof ISignalEventOccurrence) {
                    adapter = new SignalEventOccurrenceValueAdapter(debugTarget, (IEventOccurrence)((ISignalEventOccurrence)value));
                } else if (value instanceof ICallEventOccurrence) {
                    adapter = new CallEventOccurrenceValueAdapter(debugTarget, (IEventOccurrence)((ICallEventOccurrence)value));
                } else if (value instanceof ICompletionEventOccurrence) {
                    adapter = new CompletionEventOccurrenceValueAdapter(debugTarget, (IEventOccurrence)((ICompletionEventOccurrence)value));
                }
            } else if (value instanceof IToken) {
                adapter = value instanceof IObjectToken ? new ObjectTokenValueAdapter(debugTarget, (IToken)((IObjectToken)value)) : (value instanceof IForkedToken ? this.instantiate(((IForkedToken)value).getBaseToken(), debugTarget) : new TokenValueAdapter(debugTarget, (IToken)value));
            } else if (value instanceof IValue) {
                if (value instanceof IReference) {
                    adapter = value instanceof ICS_InteractionPoint ? new CS_InteractionPointValueAdapter(debugTarget, (ICS_InteractionPoint)value) : new ReferenceValueAdapter(debugTarget, (IReference)value);
                } else if (value instanceof IObject_) {
                    adapter = new ObjectValueAdapter(debugTarget, (IObject_)value);
                } else if (value instanceof IStructuredValue) {
                    adapter = new StructuredValueAdapter(debugTarget, (IStructuredValue)value);
                } else if (value instanceof IPrimitiveValue) {
                    adapter = new PrimitiveValueAdapter(debugTarget, (IPrimitiveValue)value);
                }
            } else if (value instanceof ISemanticVisitor) {
                if (value instanceof IActivityNodeActivation) {
                    if (value instanceof IAcceptEventActionActivation) {
                        adapter = new TriggeredVisitorValueAdapter(debugTarget, (ITriggeredVisitorWrapper)value);
                    } else if (value instanceof IActionActivation) {
                        adapter = new ActionActivationValueAdapter<IActionActivation>(debugTarget, (IActionActivation)value);
                    } else if (value instanceof IObjectNodeActivation) {
                        adapter = new ObjectNodeActivationValueAdapter(debugTarget, (IObjectNodeActivation)value);
                    }
                } else if (value instanceof IActivityEdgeInstance) {
                    adapter = new ActivityEdgeInstanceValueAdapter(debugTarget, (IActivityEdgeInstance)value);
                } else if (value instanceof ITransitionActivation) {
                    adapter = new TriggeredVisitorValueAdapter(debugTarget, (ITriggeredVisitorWrapper)value);
                }
            }
        }
        if (adapter == null) {
            adapter = new DefaultValueAdapter(debugTarget, value);
        }
        return adapter;
    }
}

