/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.uml.documentstructuretemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CommentChoice implements Enumerator
{
    FIRST_OWNED_COMMENT(0, "FIRST_OWNED_COMMENT", "FIRST_OWNED_COMMENT"),
    ALL_OWNED_COMMENTS(1, "ALL_OWNED_COMMENTS", "ALL_OWNED_COMMENTS");

    public static final int FIRST_OWNED_COMMENT_VALUE = 0;
    public static final int ALL_OWNED_COMMENTS_VALUE = 1;
    private static final CommentChoice[] VALUES_ARRAY;
    public static final List<CommentChoice> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CommentChoice[]{FIRST_OWNED_COMMENT, ALL_OWNED_COMMENTS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CommentChoice get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommentChoice result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommentChoice getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommentChoice result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommentChoice get(int value) {
        switch (value) {
            case 0: {
                return FIRST_OWNED_COMMENT;
            }
            case 1: {
                return ALL_OWNED_COMMENTS;
            }
        }
        return null;
    }

    private CommentChoice(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

