/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.documentstructure.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.model2doc.core.author.AuthorFactory;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.GeneratorConfigurationFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructureFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructurePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;

public class TextDocumentItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public TextDocumentItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addMainTitlePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addMainTitlePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TextDocument_mainTitle_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TextDocument_mainTitle_feature", "_UI_TextDocument_type"), (EStructuralFeature)DocumentStructurePackage.Literals.TEXT_DOCUMENT__MAIN_TITLE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(DocumentStructurePackage.Literals.DOCUMENT__DOCUMENT_GENERATOR_CONFIGURATION);
            this.childrenFeatures.add(DocumentStructurePackage.Literals.DOCUMENT__AUTHOR);
            this.childrenFeatures.add(DocumentStructurePackage.Literals.DOCUMENT__VERSION);
            this.childrenFeatures.add(DocumentStructurePackage.Literals.TEXT_DOCUMENT__TEXT_DOCUMENT_PART);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/TextDocument"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((TextDocument)object).getMainTitle();
        return label == null || label.length() == 0 ? this.getString("_UI_TextDocument_type") : String.valueOf(this.getString("_UI_TextDocument_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TextDocument.class)) {
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(DocumentStructurePackage.Literals.DOCUMENT__DOCUMENT_GENERATOR_CONFIGURATION, GeneratorConfigurationFactory.eINSTANCE.createDefaultDocumentGeneratorConfiguration()));
        newChildDescriptors.add(this.createChildParameter(DocumentStructurePackage.Literals.DOCUMENT__AUTHOR, AuthorFactory.eINSTANCE.createAuthor()));
        newChildDescriptors.add(this.createChildParameter(DocumentStructurePackage.Literals.DOCUMENT__VERSION, DocumentStructureFactory.eINSTANCE.createStringVersion()));
        newChildDescriptors.add(this.createChildParameter(DocumentStructurePackage.Literals.TEXT_DOCUMENT__TEXT_DOCUMENT_PART, DocumentStructureFactory.eINSTANCE.createBody()));
        newChildDescriptors.add(this.createChildParameter(DocumentStructurePackage.Literals.TEXT_DOCUMENT__TEXT_DOCUMENT_PART, DocumentStructureFactory.eINSTANCE.createTableOfFigures()));
        newChildDescriptors.add(this.createChildParameter(DocumentStructurePackage.Literals.TEXT_DOCUMENT__TEXT_DOCUMENT_PART, DocumentStructureFactory.eINSTANCE.createTableOfContents()));
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

