/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.GraphicCrop;
import com.sun.star.text.XTextContent;
import com.sun.star.uno.UnoRuntime;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.util.IImageCropper;

public class ImageCropper
implements IImageCropper {
    private final int topCrop;
    private final int bottomCrop;
    private final int leftCrop;
    private final int rightCrop;

    public ImageCropper(int crop) {
        this(crop, crop, crop, crop);
    }

    public ImageCropper(int topCrop, int bottomCrop, int leftCrop, int rightCrop) {
        this.topCrop = topCrop;
        this.bottomCrop = bottomCrop;
        this.leftCrop = leftCrop;
        this.rightCrop = rightCrop;
    }

    @Override
    public void crop(XTextContent xTextContent) {
        XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextContent);
        try {
            GraphicCrop crops = (GraphicCrop)propertySet.getPropertyValue("GraphicCrop");
            crops.Top = this.topCrop;
            crops.Bottom = this.bottomCrop;
            crops.Left = this.leftCrop;
            crops.Right = this.rightCrop;
            propertySet.setPropertyValue("GraphicCrop", (Object)crops);
        }
        catch (UnknownPropertyException e) {
            Activator.log.error((Throwable)e);
        }
        catch (WrappedTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Activator.log.error((Throwable)e);
        }
        catch (PropertyVetoException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

