/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.model2doc.odt.Activator;

public class ODTFileIOUtil {
    public static final String ODT_FILE_PREFIX = "file:///";

    private ODTFileIOUtil() {
    }

    public static String getFileURL(File file) {
        try {
            String canonicalPath = file.getCanonicalPath();
            StringBuilder fileURL = new StringBuilder(ODT_FILE_PREFIX);
            fileURL.append(canonicalPath.replace('\\', '/'));
            return fileURL.toString();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public static String convertFileFromWorkspacePathForLibreOffice(String path) {
        path = ODTFileIOUtil.updatePathOfFileInWorkspace(path);
        StringBuilder sb = new StringBuilder(ODT_FILE_PREFIX);
        sb.append(path);
        return sb.toString();
    }

    public static String updatePathOfFileInWorkspace(String path) {
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        if (resource == null || !new File(resource.getLocation().toString()).exists()) {
            return "";
        }
        path = resource.getLocation().toString();
        return path;
    }
}

