/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.gmf.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.accessors.IOutputFileAccessor;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructureFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Image;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.utils.DocumentStructureTemplateUtils;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractBodyPartTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;
import org.eclipse.papyrus.model2doc.gmf.documentstructuretemplate.GMFDiagramView;
import org.eclipse.papyrus.model2doc.gmf.documentstructuretemplate.GMFDocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.gmf.template2structure.internal.mapping.GMFDiagramImageUtils;

public class GMFDiagramViewMapper
extends AbstractBodyPartTemplateToStructureMapper<GMFDiagramView> {
    public GMFDiagramViewMapper() {
        super(GMFDocumentStructureTemplatePackage.eINSTANCE.getGMFDiagramView(), BodyPart.class);
    }

    protected <T> List<T> doMap(IMappingService mappingService, GMFDiagramView gmfDiagramView, EObject semanticModelElement, Class<T> returnedClassType) {
        if (!gmfDiagramView.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!gmfDiagramView.isGenerate()) {
            return Collections.emptyList();
        }
        ArrayList<T> returnedValue = new ArrayList<T>();
        Iterator diagramIter = gmfDiagramView.getMatchingDiagrams(semanticModelElement).iterator();
        while (diagramIter.hasNext()) {
            String XMI_ID;
            Image image = DocumentStructureFactory.eINSTANCE.createImage();
            Diagram current = (Diagram)diagramIter.next();
            image.setCaption(current.getName());
            DocumentTemplate t = DocumentStructureTemplateUtils.getDocumentTemplate((EObject)gmfDiagramView);
            IDocumentStructureGeneratorConfiguration conf = t.getDocumentStructureGeneratorConfiguration();
            StringBuilder imageNameBuilder = new StringBuilder(current.getName().replaceAll("\\s+", ""));
            if (current.eResource() instanceof XMIResource && (XMI_ID = ((XMIResource)current.eResource()).getID((EObject)current)) != null && !XMI_ID.isEmpty()) {
                imageNameBuilder.append("_");
                imageNameBuilder.append(XMI_ID);
            }
            IOutputFileAccessor accessor = conf.createImageOutputAccessor();
            URI uri = accessor.createOutputFileURI(imageNameBuilder.toString(), gmfDiagramView.getImageFormat().getLiteral());
            GMFDiagramImageUtils.generateImageOfDiagram(current, uri, accessor, gmfDiagramView.getDiagramImageMargin(), gmfDiagramView.getImageFormat());
            image.setFilePath(uri.toString());
            returnedValue.add(returnedClassType.cast(image));
        }
        return this.buildMapperResult((IBodySectionPartTemplate)gmfDiagramView, semanticModelElement, returnedClassType, returnedValue);
    }
}

