/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.internal.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.model2doc.core.Activator;

public class FileIOUtil {
    private FileIOUtil() {
    }

    public static String folderInWorkspaceToURL(String folderPath) {
        Object container = null;
        int nbToken = new StringTokenizer(folderPath, "/").countTokens();
        container = nbToken == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(folderPath) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        return container != null ? container.getLocation().toString() : null;
    }

    public static File createFile(String pathName, String text) {
        File file = new File(pathName);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter output = new BufferedWriter(new FileWriter(file));){
                output.write(text);
                return file;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public static void removeFile(File file) {
        java.nio.file.Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static void createFoldersPath(String foldersPath) {
        File folders = new File(foldersPath);
        if (!folders.exists()) {
            folders.mkdirs();
        }
    }
}

