/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.presentation.DocumentStructureTemplateActionBarContributor;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.Activator;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CustomDocumentStructureTemplateActionBarContributor
extends DocumentStructureTemplateActionBarContributor {
    private static final String GENERATION_CONDITION_SUB_MENU_TITLE = "Define Generation Condition";
    private static final String EXPRESSION = "Expression";

    protected Map<String, Collection<IAction>> extractSubmenuActions(Collection<IAction> createActions) {
        LinkedHashMap<String, Collection<IAction>> createSubmenuActions = new LinkedHashMap<String, Collection<IAction>>();
        if (createActions != null) {
            if (this.containsOnlyExpression(createActions)) {
                return super.extractSubmenuActions(createActions);
            }
            Iterator<IAction> actions = createActions.iterator();
            while (actions.hasNext()) {
                IAction action = actions.next();
                if (!action.getText().contains(EXPRESSION)) continue;
                ArrayList<IAction> submenuActions = (ArrayList<IAction>)createSubmenuActions.get(GENERATION_CONDITION_SUB_MENU_TITLE);
                if (submenuActions == null) {
                    submenuActions = new ArrayList<IAction>();
                    createSubmenuActions.put(GENERATION_CONDITION_SUB_MENU_TITLE, submenuActions);
                }
                submenuActions.add(action);
                actions.remove();
            }
        }
        return createSubmenuActions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        String IMAGE_PATH;
        ImageDescriptor descriptor;
        if (manager instanceof MenuManager && GENERATION_CONDITION_SUB_MENU_TITLE.equals(((MenuManager)manager).getMenuText()) && (descriptor = this.getImageDescriptor("org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui", IMAGE_PATH = "icons/GenerateBranchSubMenuIcon.png")) != null) {
            ((MenuManager)manager).setImageDescriptor(descriptor);
        }
        super.populateManager(manager, actions, contributionID);
    }

    private ImageDescriptor getImageDescriptor(String pluginId, String imagePathInPlugin) {
        ImageDescriptor imageDescriptor = Activator.getDefault().getImageRegistry().getDescriptor(imagePathInPlugin);
        if (imageDescriptor == null) {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui", (String)imagePathInPlugin);
            Activator.getDefault().getImageRegistry().put(imagePathInPlugin, imageDescriptor);
        }
        return imageDescriptor;
    }

    private boolean containsOnlyExpression(Collection<IAction> createActions) {
        for (IAction current : createActions) {
            if (current.getText().contains(EXPRESSION)) continue;
            return false;
        }
        return true;
    }
}

