/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.modelexplorer.internal.directeditor.parser;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.model2doc.documentview.Document;

public class DocumentDirectEditorParser
implements IParser {
    private String textToEdit;
    private boolean isLabelModification;

    public DocumentDirectEditorParser(String textToEdit, boolean isLabelModification) {
        this.textToEdit = textToEdit;
        this.isLabelModification = isLabelModification;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.textToEdit;
    }

    public ICommand getParseCommand(IAdaptable element, final String newString, int flags) {
        CompositeCommand result = new CompositeCommand("Rename");
        final EObject eObjectElement = (EObject)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObjectElement);
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "RenameCommand", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (eObjectElement instanceof Document && newString != null && !newString.isEmpty()) {
                    if (DocumentDirectEditorParser.this.isLabelModification) {
                        LabelInternationalizationUtils.setLabel((EObject)((Document)eObjectElement), (String)newString, null);
                    } else {
                        ((Document)eObjectElement).setName(newString);
                    }
                    return CommandResult.newOKCommandResult();
                }
                return CommandResult.newCancelledCommandResult();
            }
        };
        result.add((IUndoableOperation)cmd);
        return result;
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.textToEdit;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return null;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }
}

