/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.handler;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.command.Template2StructureCommandFactory;
import org.eclipse.papyrus.model2doc.emf.template2structure.utils.GenerateDocumentStructureUtils;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.utils.GenerateODTFileUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GenerateDocumentStructureAndODTFileHandler
extends AbstractHandler {
    private Command command;
    private TransactionalEditingDomain domain;
    private DocumentTemplate selectedDocumentTemplate;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection superResult = GenerateDocumentStructureUtils.generateDocumentStructure((TransactionalEditingDomain)this.domain, (Command)this.command, (DocumentTemplate)this.selectedDocumentTemplate);
        TextDocument textDocument = this.getTextDocument(superResult);
        if (textDocument != null) {
            GenerateODTFileUtils.generateODTFile(textDocument);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Papyrus-Model2Doc", (String)"The DocumentStructure and the ODT file have been successfully generated.");
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (this.isEnabled()) {
            this.initFields();
            this.setBaseEnabled(this.domain != null && this.command != null && this.command.canExecute());
        }
    }

    private void initFields() {
        this.resetFields();
        this.selectedDocumentTemplate = this.getSelectedDocumentTemplate();
        if (this.selectedDocumentTemplate == null) {
            return;
        }
        this.domain = TransactionUtil.getEditingDomain((EObject)this.selectedDocumentTemplate);
        if (this.domain == null) {
            return;
        }
        this.command = Template2StructureCommandFactory.eINSTANCE.getGenerateDocumentStructureCommand(this.domain, this.selectedDocumentTemplate);
    }

    private void resetFields() {
        this.domain = null;
        this.command = null;
        this.selectedDocumentTemplate = null;
    }

    private DocumentTemplate getSelectedDocumentTemplate() {
        ISelection selection;
        ISelectionService ss;
        IWorkbenchWindow wW;
        Object firstSelectedElement = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wW = wb.getActiveWorkbenchWindow()) != null && (ss = wW.getSelectionService()) != null && (selection = ss.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            firstSelectedElement = ((IStructuredSelection)selection).getFirstElement();
        }
        if (firstSelectedElement instanceof IAdaptable) {
            firstSelectedElement = ((IAdaptable)firstSelectedElement).getAdapter(EObject.class);
        }
        if (firstSelectedElement instanceof DocumentTemplate) {
            return (DocumentTemplate)firstSelectedElement;
        }
        return null;
    }

    private TextDocument getTextDocument(Object result) {
        if (result instanceof Collection) {
            return ((Collection)result).stream().filter(TextDocument.class::isInstance).map(TextDocument.class::cast).findFirst().orElse(null);
        }
        if (result instanceof TextDocument) {
            return (TextDocument)result;
        }
        return null;
    }
}

