/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.opcua.uml2opcua.qvtblackbox;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.blackbox.java.Parameter;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;

public class UtilitiesLibrary {
    protected EClass cls;

    public Date createDate(String dateStr) {
        return (Date)EcoreFactory.eINSTANCE.createFromString(EcorePackage.eINSTANCE.getEDate(), dateStr);
    }

    public FeatureMap.Entry createEfeature(String value) {
        FeatureMap.Entry newEntry = FeatureMapUtil.createCDATAEntry((String)value);
        return newEntry;
    }

    public FeatureMap.Entry createFeatureMapEntry(String literals) {
        this.setTmpModel(literals);
        return FeatureMapUtil.createEntry((EStructuralFeature)this.getLiterals(), (Object)literals);
    }

    protected void setTmpModel(String literals) {
        EAttribute stringEnum = EcoreFactory.eINSTANCE.createEAttribute();
        stringEnum.setName("LocalizedText");
        stringEnum.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.cls = EcoreFactory.eINSTANCE.createEClass();
        this.cls.getEStructuralFeatures().add((Object)stringEnum);
    }

    protected EStructuralFeature getLiterals() {
        return this.cls.getEStructuralFeature(0);
    }

    public XMLGregorianCalendar createDateTime(String dateTimeString) {
        if (dateTimeString.equals("currentDate")) {
            Date current_date = new Date();
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(current_date);
            try {
                XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
                return xmlDate;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object dob = null;
        try {
            XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateTimeString);
            System.out.println(xmlDate);
            return xmlDate;
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Operation(contextual=true)
    public static boolean before(Date self, Date when) {
        return self.before(when);
    }

    @Operation(contextual=true)
    public static List<String> split(String self, @Parameter(name="regexp") String regexp) {
        return CollectionUtil.createNewSequence(Arrays.asList(self.split(regexp)));
    }

    @Operation(contextual=true)
    public static String getQualifiedName(EClassifier self) {
        return String.valueOf(self.getEPackage().getName()) + "::" + self.getName();
    }

    public static Set<LinkedHashSet<List<Bag<Boolean>>>> testAllCollectionTypes(boolean element) {
        Bag createNewBag = CollectionUtil.createNewBag();
        createNewBag.add((Object)element);
        List createNewSequence = CollectionUtil.createNewSequence();
        createNewSequence.add(createNewBag);
        LinkedHashSet createNewOrderedSet = CollectionUtil.createNewOrderedSet();
        createNewOrderedSet.add(createNewSequence);
        Set result = CollectionUtil.createNewSet();
        result.add(createNewOrderedSet);
        return result;
    }
}

