/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ocpua.robotics.profile.opcuaroboticsprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModeEnum implements Enumerator
{
    DISCONNECTED(0, "DISCONNECTED", "DISCONNECTED"),
    CONFIRM_SAFETY(1, "CONFIRM_SAFETY", "CONFIRM_SAFETY"),
    BOOTING(2, "BOOTING", "BOOTING"),
    POWER_OFF(3, "POWER_OFF", "POWER_OFF"),
    POWER_ON(4, "POWER_ON", "POWER_ON"),
    IDLE(5, "IDLE", "IDLE"),
    BACKDRIVE(6, "BACKDRIVE", "BACKDRIVE"),
    RUNNING(7, "RUNNING", "RUNNING");

    public static final int DISCONNECTED_VALUE = 0;
    public static final int CONFIRM_SAFETY_VALUE = 1;
    public static final int BOOTING_VALUE = 2;
    public static final int POWER_OFF_VALUE = 3;
    public static final int POWER_ON_VALUE = 4;
    public static final int IDLE_VALUE = 5;
    public static final int BACKDRIVE_VALUE = 6;
    public static final int RUNNING_VALUE = 7;
    private static final ModeEnum[] VALUES_ARRAY;
    public static final List<ModeEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModeEnum[]{DISCONNECTED, CONFIRM_SAFETY, BOOTING, POWER_OFF, POWER_ON, IDLE, BACKDRIVE, RUNNING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModeEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModeEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModeEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModeEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModeEnum get(int value) {
        switch (value) {
            case 0: {
                return DISCONNECTED;
            }
            case 1: {
                return CONFIRM_SAFETY;
            }
            case 2: {
                return BOOTING;
            }
            case 3: {
                return POWER_OFF;
            }
            case 4: {
                return POWER_ON;
            }
            case 5: {
                return IDLE;
            }
            case 6: {
                return BACKDRIVE;
            }
            case 7: {
                return RUNNING;
            }
        }
        return null;
    }

    private ModeEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

