/*******************************************************************************
 * Copyright (c) 2022 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *  
 *  Contributors:
 *    Saadia Dhouib (CEA LIST) saadia.dhouib@cea.fr
 *    Fadwa Tmar (CEA LIST) fadwa.tmar@cea.fr 
 *******************************************************************************/
/**
 */
package OPC_UA_Robotics_CS_Library.util;

import OPC_UA_Robotics_CS_Library.AnalogUnitType;
import OPC_UA_Robotics_CS_Library.BaseDataVariableType;
import OPC_UA_Robotics_CS_Library.DateTime;
import OPC_UA_Robotics_CS_Library.DurationString;
import OPC_UA_Robotics_CS_Library.LocalizedText;
import OPC_UA_Robotics_CS_Library.OPC_UA_Robotics_CS_LibraryPackage;
import OPC_UA_Robotics_CS_Library.RationalNumber;
import OPC_UA_Robotics_CS_Library._3DCartesianCoordinates;
import OPC_UA_Robotics_CS_Library._3DFrameType;
import OPC_UA_Robotics_CS_Library._3DOrientation;
import OPC_UA_Robotics_CS_Library._3DVector;
import OPC_UA_Robotics_CS_Library._3DVectorType;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see OPC_UA_Robotics_CS_Library.OPC_UA_Robotics_CS_LibraryPackage
 * @generated
 */
public class OPC_UA_Robotics_CS_LibraryAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static OPC_UA_Robotics_CS_LibraryPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OPC_UA_Robotics_CS_LibraryAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = OPC_UA_Robotics_CS_LibraryPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OPC_UA_Robotics_CS_LibrarySwitch<Adapter> modelSwitch =
		new OPC_UA_Robotics_CS_LibrarySwitch<Adapter>() {
			@Override
			public Adapter case_3DFrameType(_3DFrameType object) {
				return create_3DFrameTypeAdapter();
			}
			@Override
			public Adapter case_3DCartesianCoordinates(_3DCartesianCoordinates object) {
				return create_3DCartesianCoordinatesAdapter();
			}
			@Override
			public Adapter case_3DOrientation(_3DOrientation object) {
				return create_3DOrientationAdapter();
			}
			@Override
			public Adapter caseAnalogUnitType(AnalogUnitType object) {
				return createAnalogUnitTypeAdapter();
			}
			@Override
			public Adapter caseDouble(OPC_UA_Robotics_CS_Library.Double object) {
				return createDoubleAdapter();
			}
			@Override
			public Adapter caseBaseDataVariableType(BaseDataVariableType object) {
				return createBaseDataVariableTypeAdapter();
			}
			@Override
			public Adapter caseDurationString(DurationString object) {
				return createDurationStringAdapter();
			}
			@Override
			public Adapter caseDateTime(DateTime object) {
				return createDateTimeAdapter();
			}
			@Override
			public Adapter case_3DVector(_3DVector object) {
				return create_3DVectorAdapter();
			}
			@Override
			public Adapter case_3DVectorType(_3DVectorType object) {
				return create_3DVectorTypeAdapter();
			}
			@Override
			public Adapter caseLocalizedText(LocalizedText object) {
				return createLocalizedTextAdapter();
			}
			@Override
			public Adapter caseRationalNumber(RationalNumber object) {
				return createRationalNumberAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library._3DFrameType <em>3D Frame Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library._3DFrameType
	 * @generated
	 */
	public Adapter create_3DFrameTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library._3DCartesianCoordinates <em>3D Cartesian Coordinates</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library._3DCartesianCoordinates
	 * @generated
	 */
	public Adapter create_3DCartesianCoordinatesAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library._3DOrientation <em>3D Orientation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library._3DOrientation
	 * @generated
	 */
	public Adapter create_3DOrientationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library.AnalogUnitType <em>Analog Unit Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library.AnalogUnitType
	 * @generated
	 */
	public Adapter createAnalogUnitTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library.Double <em>Double</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library.Double
	 * @generated
	 */
	public Adapter createDoubleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library.BaseDataVariableType <em>Base Data Variable Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library.BaseDataVariableType
	 * @generated
	 */
	public Adapter createBaseDataVariableTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library.DurationString <em>Duration String</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library.DurationString
	 * @generated
	 */
	public Adapter createDurationStringAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library.DateTime <em>Date Time</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library.DateTime
	 * @generated
	 */
	public Adapter createDateTimeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library._3DVector <em>3D Vector</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library._3DVector
	 * @generated
	 */
	public Adapter create_3DVectorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library._3DVectorType <em>3D Vector Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library._3DVectorType
	 * @generated
	 */
	public Adapter create_3DVectorTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library.LocalizedText <em>Localized Text</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library.LocalizedText
	 * @generated
	 */
	public Adapter createLocalizedTextAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link OPC_UA_Robotics_CS_Library.RationalNumber <em>Rational Number</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see OPC_UA_Robotics_CS_Library.RationalNumber
	 * @generated
	 */
	public Adapter createRationalNumberAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //OPC_UA_Robotics_CS_LibraryAdapterFactory
