/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.profile.ui.advices;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.aas.profile.ui.advices.AASElementTypesEnumerator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;

public class ElementConfigurationCommand
extends ConfigureElementCommand {
    private final Class element;
    private IProgressMonitor progressMonitor;
    private IAdaptable info;
    private IElementType packageelementType;
    private IElementType elementType;

    public ElementConfigurationCommand(ConfigureRequest request) {
        super(request);
        this.element = (Class)request.getElementToConfigure();
        this.elementType = request.getTypeToConfigure();
        this.setPackageTypes(this.elementType);
    }

    private void setPackageTypes(IElementType elementType) {
        if (elementType.equals(AASElementTypesEnumerator.AAS) || elementType.equals(AASElementTypesEnumerator.AAS_UI)) {
            this.packageelementType = AASElementTypesEnumerator.AAS_Package;
        } else if (elementType.equals(AASElementTypesEnumerator.ASSET) || elementType.equals(AASElementTypesEnumerator.ASSET_UI)) {
            this.packageelementType = AASElementTypesEnumerator.ASSET_Package;
        } else if (elementType.equals(AASElementTypesEnumerator.CONCEPTDESCRIPTION)) {
            this.packageelementType = AASElementTypesEnumerator.CONCEPTDESCRIPTION_Package;
        } else if (elementType.equals(AASElementTypesEnumerator.SUBMODEL) || elementType.equals(AASElementTypesEnumerator.SUBMODEL_UI)) {
            this.packageelementType = AASElementTypesEnumerator.SUBMODEL_Package;
        }
    }

    protected EObject createElement(Class element, IElementType elementType) throws ExecutionException {
        if (element == null) {
            throw new ExecutionException("element is null");
        }
        Package container = ElementConfigurationCommand.getSpecificElementPackage(element.getModel(), this.getStereotypeName());
        EObject newElement = null;
        if (container == null) {
            CreateElementRequest createElementRequest = new CreateElementRequest((EObject)element.getModel(), this.packageelementType);
            CreateElementCommand command = new CreateElementCommand(createElementRequest);
            command.execute(this.progressMonitor, this.info);
            newElement = command.getNewElement();
            if (newElement == null) {
                throw new ExecutionException("Element creation problem for " + elementType.getDisplayName() + ".");
            }
            container = (Package)newElement;
            if (this.packageelementType != null) {
                String packageName = this.getPackageName(this.packageelementType);
                container.setName(packageName);
            }
        }
        EList packagedElements = container.getPackagedElements();
        packagedElements.add((Object)element);
        return newElement;
    }

    private String getPackageName(IElementType packageelementType) {
        if (packageelementType.equals(AASElementTypesEnumerator.AAS_Package)) {
            return "AASs";
        }
        if (packageelementType.equals(AASElementTypesEnumerator.ASSET_Package)) {
            return "Assets";
        }
        if (packageelementType.equals(AASElementTypesEnumerator.CONCEPTDESCRIPTION_Package)) {
            return "ConceptDescriptions";
        }
        if (packageelementType.equals(AASElementTypesEnumerator.SUBMODEL_Package)) {
            return "Submodels";
        }
        return null;
    }

    private String getStereotypeName() {
        if (this.elementType.equals(AASElementTypesEnumerator.AAS) || this.elementType.equals(AASElementTypesEnumerator.AAS_UI)) {
            return "AAS::AssetAdministrationShell";
        }
        if (this.elementType.equals(AASElementTypesEnumerator.ASSET) || this.elementType.equals(AASElementTypesEnumerator.ASSET_UI)) {
            return "AAS::Asset";
        }
        if (this.elementType.equals(AASElementTypesEnumerator.CONCEPTDESCRIPTION)) {
            return "AAS::ConceptDescription";
        }
        if (this.elementType.equals(AASElementTypesEnumerator.SUBMODEL) || this.elementType.equals(AASElementTypesEnumerator.SUBMODEL_UI)) {
            return "AAS::Submodel";
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.progressMonitor = progressMonitor;
        this.info = info;
        this.createElement(this.element, this.packageelementType);
        return CommandResult.newOKCommandResult((Object)this.element);
    }

    private static Package getSpecificElementPackage(Model model, String stereotypeName) {
        EList packages = model.getNestedPackages();
        if (packages != null && !packages.isEmpty()) {
            for (Package p : packages) {
                if (p.getAppliedStereotypes() == null || p.getAppliedStereotype(stereotypeName) == null) continue;
                return p;
            }
        }
        return null;
    }
}

