/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IdentifiableElement implements Enumerator
{
    ASSET(0, "Asset", "Asset"),
    ASSET_ADMINISTRATION_SHELL(1, "AssetAdministrationShell", "AssetAdministrationShell"),
    CONCEPT_DESCRIPTION(2, "ConceptDescription", "ConceptDescription"),
    SUBMODEL(3, "Submodel", "Submodel");

    public static final int ASSET_VALUE = 0;
    public static final int ASSET_ADMINISTRATION_SHELL_VALUE = 1;
    public static final int CONCEPT_DESCRIPTION_VALUE = 2;
    public static final int SUBMODEL_VALUE = 3;
    private static final IdentifiableElement[] VALUES_ARRAY;
    public static final List<IdentifiableElement> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IdentifiableElement[]{ASSET, ASSET_ADMINISTRATION_SHELL, CONCEPT_DESCRIPTION, SUBMODEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IdentifiableElement get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdentifiableElement result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdentifiableElement getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdentifiableElement result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdentifiableElement get(int value) {
        switch (value) {
            case 0: {
                return ASSET;
            }
            case 1: {
                return ASSET_ADMINISTRATION_SHELL;
            }
            case 2: {
                return CONCEPT_DESCRIPTION;
            }
            case 3: {
                return SUBMODEL;
            }
        }
        return null;
    }

    private IdentifiableElement(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

