/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.submodel;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.aas.api.submodel.SubModel;
import org.eclipse.aas.api.submodel.submodelelement.Operation;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.File;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.IOperationVariable;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DEWorkspaceCreator {
    private static final Logger logger = LoggerFactory.getLogger(DEWorkspaceCreator.class);
    private SubModel subModel;
    private String nameSpace;
    private int year = Calendar.getInstance().get(1);
    private List<Operation> operations;
    private List<SubModelElementCollection> subModelSECs;
    private List<Property> properties;
    private List<File> files;

    public DEWorkspaceCreator(SubModel subModel, String nameSpace) {
        this.subModel = subModel;
        this.nameSpace = nameSpace;
        this.operations = subModel.getOperations();
        this.subModelSECs = subModel.getSubModelElementCollections();
        this.properties = subModel.getProperties();
        this.files = subModel.getFiles();
    }

    public String generateDEWorkspace() {
        String text = "/*******************************************************************************\n * Copyright (c) " + this.year + " DFKI.\n" + " *\n" + " * This program and the accompanying materials\n" + " * are made available under the terms of the Eclipse Public License 2.0\n" + " * which accompanies this distribution, and is available at\n" + " * https://www.eclipse.org/legal/epl-2.0/\n" + " *\n" + " * SPDX-License-Identifier: EPL-2.0\n" + " *\n" + " * Contributors:\n" + " *     DFKI - Tapanta Bhanja <tapanta.bhanja@dfki.de>\n" + " *******************************************************************************/\r\n" + "package " + this.nameSpace + ".module.submodels." + this.subModel.getIdShort().toLowerCase() + ";\r\n" + "import " + this.nameSpace + ".connection.ConnectedDevices;\r\n" + "import " + this.nameSpace + ".module.ConceptDescriptions;\r\n" + "\r\n" + "import java.util.Collection; \r\n" + "import java.util.LinkedList;\r\n" + "import java.util.List;\r\n" + "\r\n" + "import java.math.BigInteger; \r\n" + "\r\n" + "import javax.xml.datatype.XMLGregorianCalendar;\r\n" + "import javax.xml.datatype.Duration;\r\n" + "import javax.xml.namespace.QName;\r\n" + "\r\n" + "import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement; \r\n" + "import org.eclipse.basyx.vab.exception.provider.ProviderException; \r\n" + "import org.eclipse.basyx.vab.protocol.opcua.types.NodeId;\r\n" + "\r\n" + "/**\r\n" + " * \r\n" + " * @author DFKI \r\n" + " * \r\n" + " * Edit this file for changing operation behaviours in the respective operation body. \r\n" + " */\r\n" + "\r\n" + "public class " + "DynamicElementsWorkspace" + " {\r\n" + "\tprivate ConnectedDevices connectedDevices;\r\n" + "\tprivate ConceptDescriptions conceptDescriptions = new ConceptDescriptions();\r\n" + "\t\r\n" + "\tpublic " + "DynamicElementsWorkspace" + " (ConnectedDevices connectedDevices) {\r\n" + "\t\tthis.connectedDevices = connectedDevices; \r\n" + "\t}\r\n" + "\t\r\n" + "\r\n" + "\r\n";
        List<Object> retrievedOperations = new ArrayList();
        for (SubModelElementCollection subModelElementCollection : this.subModelSECs) {
            retrievedOperations = this.retrieveOperations(subModelElementCollection);
        }
        for (Operation operation : this.operations) {
            text = String.valueOf(text) + this.generateOperationWS(operation);
            text = String.valueOf(text) + "\r\n";
        }
        for (Operation operation : retrievedOperations) {
            text = String.valueOf(text) + this.generateOperationWS(operation);
            text = String.valueOf(text) + "\r\n";
        }
        for (SubModelElementCollection subModelElementCollection : this.subModelSECs) {
            text = String.valueOf(text) + this.generateSECWS(subModelElementCollection);
            text = String.valueOf(text) + "\r\n";
        }
        for (Property property : this.properties) {
            text = String.valueOf(text) + this.generatePropertyWS(property);
            text = String.valueOf(text) + "\r\n";
        }
        for (File file : this.files) {
            text = String.valueOf(text) + this.generateFileWS(file);
            text = String.valueOf(text) + "\r\n";
        }
        text = String.valueOf(text) + "\r\n}\r\n";
        return text;
    }

    private String generateOperationWS(Operation operation) {
        String immediateParent = "";
        if (operation.getParentSEC() != null) {
            immediateParent = operation.getParentSEC().getIdShort();
        } else if (operation.getParentSub() != null) {
            immediateParent = operation.getParentSub().getIdShort();
        } else {
            logger.error("Operation: " + operation.getIdShort() + "has no Parent defined");
        }
        List inputVariables = operation.getInputVars();
        operation.getInoutputVars();
        List outputVariables = operation.getOutputVars();
        String returnStatement = "";
        String inputVariableFormulation = "";
        String operationMethodSignature = "";
        if (operation.getOpCode().isEmpty()) {
            returnStatement = outputVariables.isEmpty() ? String.valueOf(returnStatement) + "\t\t\r\n" : String.valueOf(returnStatement) + "\t\treturn (" + this.convertBaSyxToJavaTypes(((IOperationVariable)outputVariables.get(0)).getValueType()) + ") " + this.subModel.getIdShort() + "." + immediateParent + "_" + ((IOperationVariable)outputVariables.get(0)).getValue().getIdShort() + "_" + operation.getIdShort() + "_" + "Output" + ".getValue();\r\n";
        }
        if (!inputVariables.isEmpty()) {
            for (IOperationVariable inputVariable : inputVariables) {
                inputVariableFormulation = String.valueOf(inputVariableFormulation) + this.convertBaSyxToJavaTypes(inputVariable.getValueType()) + " " + inputVariable.getValue().getIdShort() + ",";
            }
            if (inputVariableFormulation != null && inputVariableFormulation.length() > 0 && inputVariableFormulation.charAt(inputVariableFormulation.length() - 1) == ',') {
                inputVariableFormulation = inputVariableFormulation.substring(0, inputVariableFormulation.length() - 1);
            }
        }
        operationMethodSignature = !inputVariables.isEmpty() ? (!outputVariables.isEmpty() ? "\tpublic " + this.convertBaSyxToJavaTypes(((IOperationVariable)outputVariables.get(0)).getValueType()) + " " + immediateParent + "_" + operation.getIdShort() + "(" + inputVariableFormulation + ") {\r\n" + "\r\n" : "\tpublic void " + immediateParent + "_" + operation.getIdShort() + "(" + inputVariableFormulation + ") {\r\n" + "\r\n") : (!outputVariables.isEmpty() ? "\tpublic " + this.convertBaSyxToJavaTypes(((IOperationVariable)outputVariables.get(0)).getValueType()) + " " + immediateParent + "_" + operation.getIdShort() + "() {\r\n" + "\r\n" : "\tpublic void " + immediateParent + "_" + operation.getIdShort() + "() {\r\n" + "\r\n");
        String exampleOutputSet = "";
        exampleOutputSet = outputVariables != null && !outputVariables.isEmpty() ? String.valueOf(exampleOutputSet) + "\t\t * " + this.subModel.getIdShort() + "." + immediateParent + "_" + ((IOperationVariable)outputVariables.get(0)).getValue().getIdShort() + "_" + operation.getIdShort() + "_" + "Output" + "." + "setValue(<<Value Instance>>);\r\n" : "";
        String InstructionSet = "\t/**\n\t * [Note:] The method signature, if populated with parameters, are the \r\n\t * Input and InOutput parameters assigned by the user to the Operation. \r\n\t * \r\n\t * Papyrus4Manufacturing handles InOutput parameters as Input Parameters.  \r\n\t * \n\t * Please under no circumstances change/modify this method's Signature \r\n\t * and the return statement. \r\n\t * \n\t * After this methods behaviour has been defined, please use the following \r\n\t * code line (as an example) to assign the output variable of this Operation its value, \r\n\t * if and only if an OutputVariable is defined for this Operation. \r\n\t * \r\n" + exampleOutputSet + "\t *  \n" + "\t */\n";
        String opBodyText = String.valueOf(InstructionSet) + operationMethodSignature + returnStatement + "\r\n\t};\r\n";
        return opBodyText;
    }

    private String generatePropertyWS(Property property) {
        String immediateParent = "";
        if (property.getParentSEC() != null) {
            immediateParent = property.getParentSEC().getIdShort();
        } else if (property.getParentSub() != null) {
            immediateParent = property.getParentSub().getIdShort();
        } else {
            logger.error("Property: " + property.getIdShort() + "has no Parent defined");
        }
        String getterCode = "";
        Class<?> identifierClass = null;
        String InstructionSet = "";
        if (property.isDynamic()) {
            InstructionSet = "\t/**\n\t * [Note:] This method body is made available in order to define a behaviour for the property \r\n\t * under consideration, since this property is declared as dynamic. Meaning its value is subjected \r\n\t * to certain dynamism while being updated. \r\n\t * Please under no circumstances change the method signature - i.e., Return Type, \r\n\t * Method Name, Method Parameters and the Return Statement. \r\n\t * All behaviours may be defined inside the method body with available \r\n\t * parameters and one should abide by the return type for the method while \r\n\t * computing the output. \r\n\t * \r\n\t *  \n\t */\n";
            String defaultValue = "null";
            try {
                identifierClass = property.getIdentifier().getClass();
            }
            catch (NullPointerException nullPointerException) {
                logger.error("Null Pointer Exception in fetching the Identifier Type of Property: " + property.getIdShort());
            }
            if (property.getEndpoint() != null && property.getNameSpaceIndex() != 0 && property.getIdentifier() != null) {
                defaultValue = identifierClass.getSimpleName().equals("String") ? "(" + this.convertBaSyxToJavaTypes(property.getValueType()) + ") " + "this.connectedDevices." + property.getEndpoint().getName() + ".readValue(new NodeId(" + property.getNameSpaceIndex() + ", " + "\"" + property.getIdentifier() + "\"" + "))" : "(" + this.convertBaSyxToJavaTypes(property.getValueType()) + ") " + "this.connectedDevices." + property.getEndpoint().getName() + ".readValue(new NodeId(" + property.getNameSpaceIndex() + ", " + property.getIdentifier() + "))";
            } else if (property.getValue() != null) {
                defaultValue = property.getValueType().equals("String") ? "\"" + property.getValue() + "\"" : property.getValue();
            }
            String defaultGetterContent = "\t\t" + this.convertBaSyxToJavaTypes(property.getValueType()) + " defaultVar = " + defaultValue + ";\n" + "\t\treturn defaultVar;\n";
            getterCode = String.valueOf(getterCode) + "\tpublic " + this.convertBaSyxToJavaTypes(property.getValueType()) + " get_" + immediateParent + "_" + property.getIdShort() + "() {\r\n" + "\t\t\r\n" + "\t\t// Work with your Dynamic Property here. \r\n" + defaultGetterContent + "\t}\r\n" + "\r\n";
        }
        String setterCode = "";
        String finalCode = String.valueOf(InstructionSet) + getterCode + setterCode;
        return finalCode;
    }

    private String generateSECWS(SubModelElementCollection sec) {
        String immediateParent = "";
        if (sec.getParentSEC() != null) {
            immediateParent = sec.getParentSEC().getIdShort();
        } else if (sec.getParentSub() != null) {
            immediateParent = sec.getParentSub().getIdShort();
        } else {
            logger.error("SubModelElementCollection: " + sec.getIdShort() + "has no Parent defined");
        }
        List subSECS = sec.getSubModelElementCollections();
        List subProps = sec.getProperties();
        List subFiles = sec.getFiles();
        String getterCode = "";
        String setterCode = "";
        String finalCode = "";
        String InstructionSet = "\t/**\n\t * [Note:] This method body is made available in order to define a behaviour to the SubModelElementCollection \r\n\t * under consideration, since this SubModelElementCollection is declared as dynamic. Meaning its value is subjected \r\n\t * to certain dynamism while being updated. \r\n\t * This means, one could even as well consider declaring of new SubModelElements inside the SubModelElementCollection \r\n\t * method here under, if that is necessary, which will be  automatically registered inside the respective submodel. \r\n\t * Please under no circumstances change the method signature - i.e., Return Type, \r\n\t * Method Name, Method Parameters and the Return Statement. \r\n\t * All behaviours may be defined inside the method body with available \r\n\t * parameters and one should abide by the return type for the method while \r\n\t * computing the output. \r\n\t * \r\n\t *  \n\t */\n";
        if (sec.isDynamic()) {
            getterCode = String.valueOf(getterCode) + InstructionSet + "\tpublic Collection<ISubmodelElement> get_" + immediateParent + "_" + sec.getIdShort() + "() {\r\n" + "\t\tList<ISubmodelElement> " + sec.getIdShort().toLowerCase() + " = new LinkedList<>();\r\n" + "\t\t// Work with your Dynamic SubModelElementCollection here. \r\n" + "\t\treturn " + sec.getIdShort().toLowerCase() + ";\r\n" + "\t}\r\n";
            setterCode = String.valueOf(setterCode);
            finalCode = String.valueOf(getterCode) + setterCode;
            return finalCode;
        }
        if (!subProps.isEmpty()) {
            for (Property subProp : subProps) {
                finalCode = String.valueOf(finalCode) + this.generatePropertyWS(subProp);
            }
        }
        if (!subFiles.isEmpty()) {
            for (File subFile : subFiles) {
                finalCode = String.valueOf(finalCode) + this.generateFileWS(subFile);
            }
        }
        if (!subSECS.isEmpty()) {
            for (SubModelElementCollection subSEC : subSECS) {
                finalCode = String.valueOf(finalCode) + this.generateSECWS(subSEC);
            }
        }
        return finalCode;
    }

    private String generateFileWS(File file) {
        String immediateParent = "";
        if (file.getParentSEC() != null) {
            immediateParent = file.getParentSEC().getIdShort();
        } else if (file.getParentSub() != null) {
            immediateParent = file.getParentSub().getIdShort();
        } else {
            logger.error("File: " + file.getIdShort() + "has no Parent defined");
        }
        String getterCode = "";
        String setterCode = "";
        Class<?> identifierClass = null;
        String InstructionSet = "";
        if (file.isDynamic()) {
            InstructionSet = "\t/**\n\t * [Note:] This method body is made available in order to define a behaviour to the File \r\n\t * under consideration, since this File is declared as dynamic. Meaning its value is subjected \r\n\t * to certain dynamism while being updated. \r\n\t * Please under no circumstances change the method signature - i.e., Return Type, \r\n\t * Method Name, Method Parameters and the Return Statement. \r\n\t * All behaviours may be defined inside the method body with available \r\n\t * parameters and one should abide by the return type for the method while \r\n\t * computing the output. \r\n\t * \r\n\t *  \n\t */\n";
            String defaultValue = "null";
            try {
                identifierClass = file.getIdentifier().getClass();
            }
            catch (NullPointerException nullPointerException) {
                logger.error("Null Pointer Exception in fetching the Identifier Type of File: " + file.getIdShort());
            }
            if (file.getEndpoint() != null && file.getNameSpaceIndex() != 0 && file.getIdentifier() != null) {
                defaultValue = identifierClass.getSimpleName().equals("String") ? "(String) this.connectedDevices." + file.getEndpoint().getName() + ".readValue(new NodeId(" + file.getNameSpaceIndex() + ", " + "\"" + file.getIdentifier() + "\"" + "))" : "(String) this.connectedDevices." + file.getEndpoint().getName() + ".readValue(new NodeId(" + file.getNameSpaceIndex() + ", " + file.getIdentifier() + "))";
            } else if (file.getValue() != null) {
                defaultValue = "\"" + file.getValue() + "\"";
            }
            String defaultGetterContent = "\t\tString defaultVar = " + defaultValue + ";\n" + "\t\treturn defaultVar;\n";
            getterCode = String.valueOf(getterCode) + "\tpublic String get_" + immediateParent + "_" + file.getIdShort() + "() {\r\n" + "\t\t\r\n" + "\t\t// Work with your Dynamic Property here. \r\n" + defaultGetterContent + "\t}\r\n" + "\r\n";
        }
        String finalCode = String.valueOf(InstructionSet) + getterCode + setterCode;
        return finalCode;
    }

    private List<Operation> retrieveOperations(SubModelElementCollection sec) {
        ArrayList<Operation> retrievedOps = new ArrayList<Operation>();
        if (sec.getOperations() != null) {
            for (Operation operation : sec.getOperations()) {
                retrievedOps.add(operation);
            }
        }
        if (sec.getSubModelElementCollections() != null) {
            for (SubModelElementCollection collection : sec.getSubModelElementCollections()) {
                List<Operation> ops = this.retrieveOperations(collection);
                for (Operation op : ops) {
                    retrievedOps.add(op);
                }
            }
        }
        return retrievedOps;
    }

    private String convertBaSyxToJavaTypes(String valueType) {
        switch (valueType) {
            case "Int8": {
                return "Byte";
            }
            case "Int16": 
            case "UInt8": {
                return "Short";
            }
            case "UInt16": 
            case "Integer": 
            case "Int32": {
                return "Integer";
            }
            case "NonPositiveInteger": 
            case "NonNegativeInteger": 
            case "PositiveInteger": 
            case "NegativeInteger": {
                return "BigInteger";
            }
            case "UInt32": 
            case "Int64": {
                return "Long";
            }
            case "UInt64": {
                return "BigInteger";
            }
            case "Double": {
                return "Double";
            }
            case "Float": {
                return "Float";
            }
            case "Boolean": {
                return "Boolean";
            }
            case "String": {
                return "String";
            }
            case "Duration": 
            case "DayTimeDuration": {
                return "Duration";
            }
            case "YearMonthDuration": {
                return "Duration";
            }
            case "QName": {
                return "QName";
            }
            case "NOTATION": {
                return "QName";
            }
            case "AnyURI": {
                return "String";
            }
            case "LangString": {
                return "LangString";
            }
            case "Base64Binary": 
            case "HexBinary": {
                return "Byte[]";
            }
            case "GDay": 
            case "GYear": 
            case "GMonthDay": 
            case "GYearMonth": 
            case "DateTime": 
            case "GMonth": {
                return "XMLGregorianCalendar";
            }
            case "DateTimeStamp": 
            case "ID": 
            case "None": 
            case "IDREF": 
            case "AnyType": 
            case "AnySimpleType": 
            case "ENTITY": {
                return "String";
            }
        }
        return "Object";
    }
}

