/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.modulefiles;

import java.util.Calendar;
import java.util.List;
import org.eclipse.aas.api.aas.AssetAdministrationShell;
import org.eclipse.aas.api.asset.Asset;
import org.eclipse.aas.api.communications.Endpoint;
import org.eclipse.aas.api.submodel.SubModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASModuleCreator {
    private static final Logger logger = LoggerFactory.getLogger(AASModuleCreator.class);
    private int year = Calendar.getInstance().get(1);
    private String namespace;
    private AssetAdministrationShell aas;
    private Asset asset;

    public AASModuleCreator(AssetAdministrationShell aas, Asset asset, String namespace) {
        this.aas = aas;
        this.asset = asset;
        this.namespace = namespace;
        logger.info("AASModuleCreator Initialised with AAS: " + aas.getIdShort() + ", Asset: " + asset.getIdShort() + " and namespace: " + this.namespace);
    }

    public String createAASServer() {
        String text = "/*******************************************************************************\r\n * Copyright (c) " + this.year + " DFKI.\n" + " *\r\n" + " * This program and the accompanying materials are made\r\n" + " * available under the terms of the Eclipse Public License 2.0\r\n" + " * which is available at https://www.eclipse.org/legal/epl-2.0/\r\n" + " *\r\n" + " * SPDX-License-Identifier: EPL-2.0\r\n" + " * Contributor:\r\n" + " * \t\tDFKI - Tapanta Bhanja <tapanta.bhanja@dfki.de>\r\n" + "\t*\t\tFESTO - Moritz Marseu <moritz.marseu@festo.com>\r\n" + " ******************************************************************************/\r\n" + "package " + this.namespace + ".module;\r\n" + "\r\n" + "import java.io.IOException;\r\n" + "import org.apache.commons.cli.CommandLine;\r\n" + "import org.apache.commons.cli.DefaultParser;\r\n" + "import org.apache.commons.cli.HelpFormatter;\r\n" + "import org.apache.commons.cli.Options;\r\n" + "import org.apache.commons.cli.ParseException;\r\n" + "\r\n" + "import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;\r\n" + "import org.eclipse.basyx.vab.protocol.http.server.BaSyxHTTPServer;\r\n" + "import com.festo.aas.p4m.configuration.CommandLineOptions;\r\n" + "\r\n" + "import org.slf4j.Logger;\r\n" + "import org.slf4j.LoggerFactory;\r\n" + "\r\n" + "import " + this.namespace + ".connection.ConnectedDevices;\r\n" + "\r\n" + "/**\r\n" + " * The central class of this AAS application. This class contains the main method which createst the AAS Model\r\n" + " * and launches the server which exposes the model on the network. \r\n" + " * \r\n" + " * @author DFKI\r\n" + " *\r\n" + " */\r\n" + "public class AASServer extends BaSyxHTTPServer {\r\n" + "\t\r\n" + "\tprivate static final Logger logger = LoggerFactory.getLogger(AASServer.class);\r\n" + "\tprivate static Settings configuration;\r\n" + "\tprivate static AASModels models;\r\n" + "\tprivate static ConnectedDevices connectors;\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Creates a new instance of this application. \r\n" + "\t * \r\n" + "\t * @param context\tA context object which contains data needed for the server. \r\n" + "\t * \r\n" + "\t */\r\n" + "\tprivate AASServer(BaSyxContext context) {\r\n" + "\t\tsuper(context);\r\n" + "\t}\r\n" + "\r\n" + "\t/**\r\n" + "\t * This main method creates all required objects and launches a server exposing this AAS Model on the network. \r\n" + "\t * \r\n" + "\t * @param args\r\n" + "\t * @throws IOException \r\n" + "\t */\r\n" + "\tpublic static void main(String[] args) throws Exception {\r\n" + "\t\t\r\n" + "\t\tCommandLine cmd = parseCommandLine(args);\r\n" + "\t\t// Load application settings\r\n" + "\t\tif(cmd.hasOption(\"p\")) {\r\n" + "\t\t\tconfiguration = new Settings(cmd.getOptionValue(\"p\"));\r\n" + "\t\t}\r\n" + "\t\t\r\n" + "\t\telse { \r\n" + "\t\t\tconfiguration = new Settings();\r\n" + "\t\t}\r\n" + "\t\t\r\n" + "\t\tconfiguration.load();\r\n" + "\t\t\r\n" + "\t\tconnectors = new ConnectedDevices();\r\n" + "\t\tmodels = new AASModels();\r\n" + "\t\t\r\n" + "\t\tBaSyxContext context = DeviceContext.forModels(models);\r\n" + "\t\tAASServer app = new AASServer(context);\r\n" + "\t\tapp.start();\r\n" + "\t\t\r\n" + "\t\tif (app.hasEnded()) {\r\n" + "            logger.error(\"AAS server failed to start. Process is terminating.\");\r\n" + "            System.exit(1);\r\n" + "        } \r\n" + "\t\telse {\r\n" + "        \tString contextPath = \"/aas\";\r\n" + "            String serverUrl = String.format(\"http://%s:%d%s\", configuration.applicationHostname.get(), configuration.applicationPort.get(),\r\n" + "                    contextPath);\r\n" + "            logger.info(\"AAS '{}' is listening at: {}\", configuration.aasName.get(), serverUrl);\r\n" + "            logger.info(\r\n" + "                    \"You can find the API documentation at https://app.swaggerhub.com/apis/BaSyx/basyx_submodel_repository_http_rest_api/v1#/\");\r\n" + "        }\r\n" + "\r\n" + "\t}\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Gets the AAS models this application is serving. \r\n" + "\t * \r\n" + "\t * @return The models this AAS is serving. \r\n" + "\t */\r\n" + "\tpublic static AASModels getModels() {\r\n" + "\t\treturn models;\r\n" + "\t}\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Gets an object which contains all configured connectors to external servers. \r\n" + "\t * \r\n" + "\t * @return An object with all configured connectors. \r\n" + "\t */\r\n" + "\tpublic static ConnectedDevices getConnectors() {\r\n" + "\t\treturn connectors;\r\n" + "\t}\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Gets the object which contains the externalised configuration properties.\r\n" + "\t * \r\n" + "\t * <p>\r\n" + "\t * Some settings for this application can be easily changed in a text file without touching the \r\n" + "\t * source code. These settings are available from this object. \r\n" + "\t * \r\n" + "\t * @return The configuration object.\r\n" + "\t */\r\n" + "\tpublic static Settings getSettings() {\r\n" + "\t\treturn configuration;\r\n" + "\t}\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Parses the command line arguments passed to this application.\r\n" + "\t * \r\n" + "\t * <p>\r\n" + "\t * A set of default options are taken from {@link CommandLineOptions#getDefaultOptions()}. This\r\n" + "\t * application could add its own additional options, if required.\r\n" + "\t * \r\n" + "\t * <p>\r\n" + "\t * If the command line can't be parsed, a help text is displayed on STDOUT and the application\r\n" + "\t * exits.\r\n" + "\t * \r\n" + "\t * @param args The command line arguments passed to this application.\r\n" + "\t * \r\n" + "\t * @author Moritz Marseu\r\n" + "\t * \r\n" + "\t * @return The parsed command line.\r\n" + "\t */\r\n" + "\tprivate static CommandLine parseCommandLine(String[] args) {\r\n" + "  \r\n" + "\t\tOptions options = CommandLineOptions.getDefaultOptions();\r\n" + "\r\n" + "\t\tDefaultParser parser = new DefaultParser();\r\n" + "     \r\n" + "\t\ttry {\r\n" + "         \r\n" + "\t\t\treturn parser.parse(options, args);\r\n" + "     \r\n" + "\t\t} catch (ParseException e) {\r\n" + "         \r\n" + "\t\t\tHelpFormatter help = new HelpFormatter();\r\n" + "         \r\n" + "\t\t\thelp.printHelp(\"java -jar <jar_file>\", options);\r\n" + "         \r\n" + "\t\t\tSystem.exit(1);\r\n" + "         \r\n" + "\t\t\treturn null;\r\n" + "\t\t}\r\n" + "\t}\r\n" + "\r\n" + "}\r\n" + "\r\n" + "\r\n";
        logger.info("AASServer code generated successfully!");
        return text;
    }

    public String createDeviceContext() {
        String text = "/*******************************************************************************\r\n * Copyright (c) " + this.year + " DFKI.\n" + " *\r\n" + " * This program and the accompanying materials are made\r\n" + " * available under the terms of the Eclipse Public License 2.0\r\n" + " * which is available at https://www.eclipse.org/legal/epl-2.0/\r\n" + " *\r\n" + " * SPDX-License-Identifier: EPL-2.0\r\n" + " * Contributor:\r\n" + " * \t\tDFKI - Tapanta Bhanja <tapanta.bhanja@dfki.de>\r\n" + " ******************************************************************************/\r\n" + "package " + this.namespace + ".module;\r\n" + "\r\n" + "import javax.servlet.http.HttpServlet;\r\n" + "import org.eclipse.basyx.aas.restapi.AASModelProvider;\r\n" + "import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;\r\n" + "import org.eclipse.basyx.submodel.restapi.SubmodelProvider;\r\n" + "import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;\r\n" + "import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;\r\n" + "import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;\r\n" + "\r\n" + "/**\r\n" + " * Device Context returns an Object of Type 'BaSyxContext' for each SubModels. \r\n" + " */\r\n" + "public final class DeviceContext {\r\n" + "\t\r\n" + "\tpublic static BaSyxContext forModels(AASModels models) {\r\n" + "\t\t\r\n" + "\t\tString hostName = AASServer.getSettings().applicationHostname.get();\r\n" + "\t\tint port = AASServer.getSettings().applicationPort.get();\r\n" + "\t\tBaSyxContext context = new BaSyxContext(\"\", \"\", hostName, port);\r\n" + "\t\t\r\n" + "\t\tMultiSubmodelProvider aasProvider = new MultiSubmodelProvider();\r\n" + "\t\taasProvider.setAssetAdministrationShell(new AASModelProvider(models.aas));\r\n" + "\t\t\r\n" + "\t\tmodels.getSubmodels().forEach((sm) -> {\r\n" + "\t\t\taasProvider.addSubmodel(new SubmodelProvider(sm.getSubmodel()));\r\n" + "\t\t});\r\n" + "\t\t\r\n" + "\t\tHttpServlet servlet = new VABHTTPInterface<IModelProvider>(aasProvider);\r\n" + "\t\tcontext.addServletMapping(\"/*\", servlet);\r\n" + "\t\t\r\n" + "\t\treturn context;\r\n" + "\t\t\r\n" + "\t}\r\n" + "}";
        logger.info("DeviceContext code generated successfully!");
        return text;
    }

    public String createAASModels() {
        String subModelImports = "";
        String fieldBody = "";
        String constructorBody = "";
        List subModels = this.aas.getSubModels();
        for (SubModel subModel : subModels) {
            subModelImports = String.valueOf(subModelImports) + "import " + this.namespace + ".module.submodels." + subModel.getIdShort().toLowerCase() + "." + subModel.getIdShort() + "; \r\n";
            fieldBody = String.valueOf(fieldBody) + "\t/** The submodel '" + subModel.getIdShort() + "'. */ \r\n" + "\tpublic final SubmodelWrapper " + subModel.getIdShort() + ";\r\n" + "\t\r\n";
            constructorBody = String.valueOf(constructorBody) + "\t\t" + subModel.getIdShort() + " = new SubmodelWrapper(new " + subModel.getIdShort() + "());\r\n" + "\t\taas.addSubmodel(" + subModel.getIdShort() + ".getSubmodel());\r\n" + "\t\tlistSubmodels.add(" + subModel.getIdShort() + "); \r\n";
        }
        String text = "/*******************************************************************************\r\n * Copyright (c) " + this.year + " DFKI.\n" + " *\r\n" + " * This program and the accompanying materials\r\n" + " * are made available under the terms of the Eclipse Public License 2.0\r\n" + " * which accompanies this distribution, and is available at\r\n" + " * https://www.eclipse.org/legal/epl-2.0/\r\n" + " *\r\n" + " * SPDX-License-Identifier: EPL-2.0\r\n" + " *\r\n" + " * Contributors:\r\n" + " *     DFKI - Tapanta Bhanja <tapanta.bhanja@dfki.de>\r\n" + " *******************************************************************************/\r\n" + "package " + this.namespace + ".module;\r\n" + "\r\n" + "import java.net.URI;\r\n" + "import java.util.Arrays;\r\n" + "import java.util.HashSet;\r\n" + "import java.util.Set;\r\n" + "\r\n" + "import org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind;\r\n" + "import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;\r\n" + "import org.eclipse.basyx.aas.metamodel.map.parts.Asset;\r\n" + "import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;\r\n" + "import com.festo.aas.p4m.connection.SubmodelWrapper;\r\n" + "\r\n" + subModelImports + "\r\n" + "/**\r\n" + " * Contains the major components of the AAS Model.\r\n" + " * \r\n" + " * <p>\r\n" + " * 'AAS Model' - includes the AAS itself the assets and the submodels. \r\n" + " * \r\n" + " * <p>\r\n" + " * This class creates and exposes the AAS itself as well as its asset, concept descriptions and submodels. \r\n" + " * \r\n" + " * @author DFKI\r\n" + " *\r\n" + " */ \r\n" + "public class AASModels { \r\n" + "\r\n" + "\t/** The asset represented by this AAS. */\r\n" + "\tpublic final Asset asset;\r\n" + "\t\r\n" + "\t/** The AAS object itself. */\r\n" + "\tpublic final AssetAdministrationShell aas;\r\n" + "\t\r\n" + "\t/** Holds all concept descriptions. */\r\n" + "\tpublic final ConceptDescriptions conceptDescriptions;\r\n" + "\r\n" + "\t/** List of Submodels. **/\r\n" + "\tpublic final Set<SubmodelWrapper> listSubmodels = new HashSet<>();\r\n" + "\t\r\n" + "\t" + fieldBody + "\t\r\n" + "\t/**\r\n" + "\t * Constructor Method.\r\n" + "\t * Creates all components of this AAS model and stores references to them in fields. \r\n" + "\t */\r\n" + "\tpublic AASModels() {\r\n" + "\t\t\r\n" + "\t\tSettings settings = AASServer.getSettings();\t\r\n" + "\t\tString assetIdShort = settings.assetName.get();\r\n" + "\t\tURI assetId = settings.assetUri.get();\t\t\t\r\n" + "\t\tString aasIdShort = settings.aasName.get();\r\n" + "\t\tURI aasId = settings.aasUri.get();\r\n" + "\t\t\r\n" + "\t\t\r\n" + "\t\taas = createAas(aasIdShort, aasId);\r\n" + "\t\t\r\n" + "\t\tasset = createAsset(assetIdShort, assetId);\r\n" + "\t\taas.setAsset(asset);\r\n" + "\t\t\r\n" + "\t\tconceptDescriptions = new ConceptDescriptions();\r\n" + "\t\taas.setConceptDictionary(Arrays.asList(conceptDescriptions));\r\n" + "\t\t\r\n" + constructorBody + "\t}\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Creates an asset object with the given idShort and id. \r\n" + "\t * \r\n" + "\t * @param idShort\tThe asset's idShort. \r\n" + "\t * @param id\t\tThe asset's globally unique id. Must be an IRI. (i.e., an URI)\r\n" + "\t * \r\n" + "\t * @return\t\t\tThe created asset. \r\n" + "\t */\r\n" + "\tprivate Asset createAsset(String idShort, URI id) {\r\n" + "\t\t\r\n" + "\t\tAsset asset = new Asset();\r\n" + "\t\tasset.setAssetKind(AssetKind.INSTANCE);\r\n" + "\t\tasset.setIdShort(idShort);\r\n" + "\t\tasset.setIdentification(IdentifierType.IRI, id.toString());\r\n" + "\t\t\r\n" + "\t\treturn asset;\r\n" + "\t\t\r\n" + "\t}\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Creates an AAS object with the given idShort and id. \r\n" + "\t * \r\n" + "\t * @param idShort\tThe AAS' idShort.\r\n" + "\t * @param id\t\tThe AAS' globally unique id. Must be an IRI (i.e., an URI)\r\n" + "\t * \r\n" + "\t * @return\t\t\tThe created AAS.\r\n" + "\t */\r\n" + "\tprivate AssetAdministrationShell createAas(String idShort, URI id) {\r\n" + "\t\tAssetAdministrationShell aas = new AssetAdministrationShell();\r\n" + "\t\taas.setIdShort(idShort);\r\n" + "\t\taas.setIdentification(IdentifierType.IRI, id.toString());\r\n" + "\t\t\r\n" + "\t\treturn aas;\r\n" + "\t}\r\n" + "\t\r\n" + "\t\r\n" + "\tpublic Set<SubmodelWrapper> getSubmodels() {\r\n" + "\t\treturn listSubmodels;\r\n" + "\t}\r\n" + "\r\n" + "}";
        logger.info("AASModels code generated successfully!");
        return text;
    }

    public String createSettings() {
        String text = "";
        String serverFields = "";
        String subModelFields = "";
        List endpoints = this.asset.getEndpoints();
        List subModels = this.aas.getSubModels();
        for (Endpoint endpoint : endpoints) {
            serverFields = String.valueOf(serverFields) + "/**\r\n\t * The address of the endpoint named '" + endpoint.getName() + "'.\r\n" + "\t */\r\n" + "\t@LoadableProperty\r\n" + "\tpublic final StringProperty " + endpoint.getName() + " = new StringProperty(\"asset.endpoint." + endpoint.getName() + "\", new UrlValidator());\r\n" + "\t\r\n";
        }
        for (SubModel subModel : subModels) {
            if (subModel.getKind().toString() == "INSTANCE") {
                if (subModel.getIdentification().getIdType().toString() == "IRDI") {
                    throw new IllegalStateException("Submodel of ModelingKind - INSTANCE does not support IRDI as IdentifierType according to the Details of the Asset Administration Shell (Page 36). \r\nSet SubModel IdentifierType to IRI or CUSTOM.");
                }
                if (subModel.getIdentification().getIdType().toString() == "IRI") {
                    subModelFields = String.valueOf(subModelFields) + "\t@LoadableProperty\r\n\tpublic final UriProperty SUBMODEL_" + subModel.getIdShort().toUpperCase() + "_IRI = new UriProperty(\"submodel." + subModel.getIdShort() + ".uri\");\r\n" + "\r\n";
                    continue;
                }
                if (subModel.getIdentification().getIdType().toString() != "CUSTOM") continue;
                subModelFields = String.valueOf(subModelFields) + "\t@LoadableProperty\r\n\tpublic final StringProperty SUBMODEL_" + subModel.getIdShort().toUpperCase() + "_CUSTOM = new StringProperty(\"submodel." + subModel.getIdShort() + ".custom\");\r\n" + "\r\n";
                continue;
            }
            if (subModel.getKind().toString() != "TEMPLATE") continue;
            if (subModel.getIdentification().getIdType().toString() == "IRDI") {
                subModelFields = String.valueOf(subModelFields) + "\t@LoadableProperty\r\n\tpublic final StringProperty SUBMODEL_" + subModel.getIdShort().toUpperCase() + "_IRDI = new StringProperty(\"submodel." + subModel.getIdShort() + ".irdi\");\r\n" + "\r\n";
                continue;
            }
            if (subModel.getIdentification().getIdType().toString() == "IRI") {
                subModelFields = String.valueOf(subModelFields) + "\t@LoadableProperty\r\n\tpublic final UriProperty SUBMODEL_" + subModel.getIdShort().toUpperCase() + "_IRI = new UriProperty(\"submodel." + subModel.getIdShort() + ".uri\");\r\n" + "\r\n";
                continue;
            }
            if (subModel.getIdentification().getIdType().toString() != "CUSTOM") continue;
            throw new IllegalStateException("Submodel of ModelingKind - TEMPLATE does not support CUSTOM as IdentifierType according to the Details of the Asset Administration Shell (Page 36). \r\nSet SubModel IdentifierType to IRI or IRDI.");
        }
        text = "/*******************************************************************************\r\n * Copyright (c) " + this.year + " DFKI.\n" + " *\r\n" + " * This program and the accompanying materials\r\n" + " * are made available under the terms of the Eclipse Public License 2.0\r\n" + " * which accompanies this distribution, and is available at\r\n" + " * https://www.eclipse.org/legal/epl-2.0/\r\n" + " *\r\n" + " * SPDX-License-Identifier: EPL-2.0\r\n" + " *\r\n" + " * Contributors:\r\n" + " *     DFKI - Tapanta Bhanja <tapanta.bhanja@dfki.de>\r\n" + " *******************************************************************************/\r\n" + "package " + this.namespace + ".module;\r\n" + "\r\n" + "import java.io.IOException;\r\n" + "\r\n" + "import com.festo.aas.p4m.configuration.AasProperties;\r\n" + "import com.festo.aas.p4m.configuration.LoadableProperty;\r\n" + "import com.festo.aas.p4m.validators.UrlValidator;\r\n" + "\r\n" + "/**\r\n" + " * Holds the settings for this AAS application. For more details, refer to {@link AasProperties}\r\n" + " * @author DFKI\r\n" + " *\r\n" + " */\r\n" + "\r\n" + "public final class Settings extends AasProperties {\r\n" + "\t\r\n" + "\t" + serverFields + "\t\r\n" + "\t/**\r\n" + "\t * The URI identifying the Submodels. This serves as the submodel's global unique id.\r\n" + "\t * \r\n" + "\t * <p>\r\n" + "\t * This is can be an URL[Uniform Resource Locator] (e.g. <code>http://www.example.com/myAAS1234/</code>), an URN\r\n" + "\t * [Uniform Resource Name] (e.g. <code>urn:uuid:6e8bc430-9c3a-11d9-9669-0800200c9a66</code>)\r\n" + "\t * \r\n" + "\t * <p>\r\n" + "\t * This is merely an identifier. Even if an URL is specified, this URL isn't required to be accessible on any network. \r\n" + "\t * \r\n" + "\t */ \r\n" + subModelFields + "\r\n" + "\t/**\r\n" + "\t * Creates a new settings object using the default properties file path. \r\n" + "\t * \r\n" + "\t *  <p>\r\n" + "\t *  Default values are automatically loaded from the resource file\r\n" + "\t *  {@link #DEFAULT_PROPERTIES_RESOURCE} within this constructor. User-defined values are loaded in \r\n" + "\t *  {@link #load()} instead, which must be called, before any property values can be accessed. \r\n" + "\t *  \r\n" + "\t * @throws IOException if the resource file with the default values can't be loaded.\r\n" + "\t * \r\n" + "\t */\r\n" + "\tprotected Settings() throws IOException {\r\n" + "\t\tsuper();\r\n" + "\t}\r\n" + "\t\r\n" + "\t/**\r\n" + "\t * Creates a new settings object using the specified properties in the file path. \r\n" + "\t * \r\n" + "\t *  <p>\r\n" + "\t *  Default values are automatically loaded from the resource file\r\n" + "\t *  {@link #DEFAULT_PROPERTIES_RESOURCE} within this constructor. User-defined values are loaded in \r\n" + "\t *  {@link #load()} instead, which must be called, before any property values can be accessed. \r\n" + "\t *  \r\n" + "\t * @throws IOException if the resource file with the default values can't be loaded.\r\n" + "\t * \r\n" + "\t */\r\n" + "\tpublic Settings(String userFilepath) throws IOException {\r\n" + "\t\tsuper(userFilepath);\r\n" + "\t}\r\n" + "\r\n" + "}\r\n";
        logger.info("Settings code generated successfully!");
        return text;
    }
}

