/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bpmn.advices;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;

public class ActivityConfigurationCommand
extends ConfigureElementCommand {
    private final Activity activity;
    private IProgressMonitor progressMonitor;
    private IAdaptable info;
    private IElementType elementType;
    private final IElementType operationElementType;

    public ActivityConfigurationCommand(ConfigureRequest request) {
        super(request);
        this.activity = (Activity)request.getElementToConfigure();
        this.elementType = request.getTypeToConfigure();
        this.operationElementType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Operation_Operation");
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.progressMonitor = monitor;
        this.info = info;
        this.createElement(this.activity, this.operationElementType);
        return CommandResult.newOKCommandResult((Object)this.activity);
    }

    protected EObject createElement(Activity activity, IElementType elementType) throws ExecutionException {
        if (activity == null) {
            throw new ExecutionException("element is null");
        }
        EObject newElement = null;
        Element container = activity.getOwner();
        if (container != null) {
            CreateElementRequest createElementRequest = new CreateElementRequest((EObject)container, this.operationElementType);
            CreateElementCommand command = new CreateElementCommand(createElementRequest);
            command.execute(this.progressMonitor, this.info);
            newElement = command.getNewElement();
            if (newElement != null) {
                Operation newOperation = (Operation)newElement;
                newOperation.getMethods().add((Object)activity);
                newOperation.setName("workflow");
            } else {
                throw new ExecutionException("Operation creation problem!");
            }
        }
        return newElement;
    }
}

