/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.tableProvider;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.aas.AASFactory;
import org.eclipse.papyrus.aas.Entity;
import org.eclipse.papyrus.aas.LangEnum;
import org.eclipse.papyrus.aas.LangString;
import org.eclipse.papyrus.aas.Operation;
import org.eclipse.papyrus.aas.Property;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.uml.nattable.manager.cell.StereotypePropertyCellManager;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DescriptionLangStringCollectionCellManager
extends StereotypePropertyCellManager {
    private static final String BOM_TABLE_TYPE = "BOMTableType";
    private static final String PROPERTY_TABLE_TYPE = "PropertiesTableType";
    private static final String OPERATION_TABLE_TYPE = "OperationsTableType";
    private static final String DESCRIPTION = "description";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        boolean res = super.handles(columnElement, rowElement, tableManager);
        if (res) {
            List umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
            res = umlObjects.get(1) instanceof String && ((String)umlObjects.get(1)).endsWith(DESCRIPTION);
        }
        return res;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        Object res = null;
        try {
            res = super.doGetValue(columnElement, rowElement, tableManager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        return super.getOrCreateStringValueConverterClass(existingConverters, multiValueSeparator, tableManager);
    }

    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueSolver, INattableModelManager tableManager) {
        CompositeCommand cc = new CompositeCommand("description LangString command");
        String tableType = tableManager.getTable().getTableConfiguration().getType();
        LangString langstring = AASFactory.eINSTANCE.createLangString();
        langstring.setLang(LangEnum.EN);
        langstring.setValue(newValue);
        if (tableType.equals(BOM_TABLE_TYPE)) {
            Entity ModelProp = (Entity)UMLUtil.getStereotypeApplication((Element)((Element)rowElement), Entity.class);
            ModelProp.getDescription().add(0, (Object)langstring);
        } else if (tableType.equals(OPERATION_TABLE_TYPE)) {
            Operation ModelProp = (Operation)UMLUtil.getStereotypeApplication((Element)((Element)rowElement), Operation.class);
            ModelProp.getDescription().add(0, (Object)langstring);
        } else if (tableType.equals(PROPERTY_TABLE_TYPE)) {
            Property ModelProp = (Property)UMLUtil.getStereotypeApplication((Element)((Element)rowElement), Property.class);
            ModelProp.getDescription().add(0, (Object)langstring);
        }
        return GMFtoEMFCommandWrapper.wrap((ICommand)cc);
    }
}

