/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.tables.configurations.editors;

import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.aas.Asset;
import org.eclipse.papyrus.aas.ConceptDescription;
import org.eclipse.papyrus.aas.IdentifierType;
import org.eclipse.papyrus.aas.Key;
import org.eclipse.papyrus.aas.KeyElements;
import org.eclipse.papyrus.aas.KeyType;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.celleditor.IActionCellEditor;
import org.eclipse.papyrus.infra.nattable.celleditor.action.AbstractOpenDialogCellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.properties.celleditor.PropertyDialogCellEditor;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreateKeyTypeCellEditorButtonAction
extends AbstractOpenDialogCellEditorButtonAction {
    private List<IElementType> elementsForCreation;
    private IElementType selectedElementType = null;
    private EObject creationContext;
    private boolean onlyOnEmptyCell;

    public CreateKeyTypeCellEditorButtonAction(List<IElementType> elementsForCreation, boolean onlyOnEmptyCell, EObject context) {
        this.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.setText("");
        this.setTooltipText("Create a new Reference");
        this.elementsForCreation = elementsForCreation;
        this.onlyOnEmptyCell = onlyOnEmptyCell;
        this.creationContext = context;
    }

    public AbstractDialogCellEditor createDialogCellEditor() {
        return new PropertyDialogCellEditor();
    }

    public static Key getStereotypeApplication(Element element) {
        Key key = null;
        if (element != null) {
            key = (Key)UMLUtil.getStereotypeApplication((Element)element, Key.class);
        }
        return key;
    }

    public static Asset getAsset(Element element) {
        Asset conceptDescription = null;
        if (element != null) {
            conceptDescription = (Asset)UMLUtil.getStereotypeApplication((Element)element, Asset.class);
        }
        return conceptDescription;
    }

    public static ConceptDescription getConceptDescritpion(Element element) {
        ConceptDescription conceptDescription = null;
        if (element != null) {
            conceptDescription = (ConceptDescription)UMLUtil.getStereotypeApplication((Element)element, ConceptDescription.class);
        }
        return conceptDescription;
    }

    public int runAction(final SelectionEvent e) {
        this.openMenuForCreation(this.parent);
        if (this.selectedElementType != null) {
            INattableModelManager modelManager = (INattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            ILayerCell cell = this.cell;
            cell.getColumnIndex();
            cell.getRowIndex();
            final Object key = modelManager.getRowElement(this.getRowIndex());
            this.creationContext = modelManager.getTable().getContext();
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            CreateElementRequest request = this.createCreateElementRequest(editingDomain, this.creationContext, this.selectedElementType, null);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.creationContext);
            if (provider != null) {
                final ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
                AbstractTransactionalCommand abs = new AbstractTransactionalCommand(editingDomain, "Create and Edit new element", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                        cmd.execute(arg0, arg1);
                        CommandResult res = cmd.getCommandResult();
                        Object value = res.getReturnValue();
                        Object previousCanonicalValue = CreateKeyTypeCellEditorButtonAction.this.originalCanonicalValue;
                        CreateKeyTypeCellEditorButtonAction.this.originalCanonicalValue = value;
                        int resIntermediare = CreateKeyTypeCellEditorButtonAction.super.runAction(e);
                        if (resIntermediare == 0) {
                            EObject element;
                            if (key instanceof EObjectTreeItemAxis && (element = ((EObjectTreeItemAxis)key).getElement()) instanceof Element) {
                                Key key2 = CreateKeyTypeCellEditorButtonAction.getStereotypeApplication((Element)element);
                                ConceptDescription cd = null;
                                Asset asset = null;
                                if (value instanceof Element && CreateKeyTypeCellEditorButtonAction.getConceptDescritpion((Element)value) != null && (cd = CreateKeyTypeCellEditorButtonAction.getConceptDescritpion((Element)value)) != null && cd.getIdentification() != null) {
                                    key2.setType(KeyElements.CONCEPT_DESCRIPTION);
                                    key2.setIdType(CreateKeyTypeCellEditorButtonAction.this.getKeyType(cd.getIdentification().getIdType()));
                                    key2.setValue(cd.getIdentification().getId());
                                }
                                if (value instanceof Element && CreateKeyTypeCellEditorButtonAction.getAsset((Element)value) != null && (asset = CreateKeyTypeCellEditorButtonAction.getAsset((Element)value)) != null && asset.getIdentification() != null) {
                                    key2.setType(KeyElements.ASSET);
                                    key2.setIdType(CreateKeyTypeCellEditorButtonAction.this.getKeyType(asset.getIdentification().getIdType()));
                                    key2.setValue(asset.getIdentification().getId());
                                }
                            }
                            return CommandResult.newOKCommandResult((Object)value);
                        }
                        this.setResult(CommandResult.newCancelledCommandResult());
                        CreateKeyTypeCellEditorButtonAction.this.originalCanonicalValue = previousCanonicalValue;
                        return this.getCommandResult();
                    }
                };
                this.getEditingDomain().getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)abs));
                CommandResult res = abs.getCommandResult();
                if (res.getStatus().isOK()) {
                    this.selectedElementType = null;
                    return 0;
                }
            }
        }
        this.selectedElementType = null;
        return 1;
    }

    private KeyType getKeyType(IdentifierType idType) {
        switch (idType.getValue()) {
            case 0: {
                return KeyType.CUSTOM;
            }
            case 2: {
                return KeyType.IRI;
            }
            case 1: {
                return KeyType.IRDI;
            }
        }
        return KeyType.CUSTOM;
    }

    private void openMenuForCreation(Composite parent) {
        if (this.elementsForCreation.size() == 0) {
            return;
        }
        if (this.elementsForCreation.size() == 1) {
            this.selectedElementType = this.elementsForCreation.get(0);
            return;
        }
        Menu menu = new Menu((Control)parent);
        String ELEMENT_TYPE = "elementTypeId";
        for (IElementType current : this.elementsForCreation) {
            final MenuItem item = new MenuItem(menu, 0);
            item.setText(current.getDisplayName());
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)current.getIconURL());
            item.setImage(Activator.getDefault().getImage(imgDesc));
            item.setData("elementTypeId", (Object)current);
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CreateKeyTypeCellEditorButtonAction.this.setSelectedElementType((IElementType)item.getData("elementTypeId"));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        menu.setVisible(true);
        Display display = Display.getDefault();
        while (menu.isVisible()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }

    private void setSelectedElementType(IElementType elementType) {
        this.selectedElementType = elementType;
    }

    protected void setCreationContext(EObject creationContext) {
        this.creationContext = creationContext;
    }

    protected CreateElementRequest createCreateElementRequest(TransactionalEditingDomain editingDomain, EObject container, IElementType elementType, EReference containmentFeature) {
        return new CreateElementRequest(editingDomain, container, elementType, containmentFeature);
    }

    public boolean configureAction(IActionCellEditor editor, Composite parent, Object originalCanonicalValue, ILayerCell cell, IConfigRegistry configRegistry) {
        super.configureAction(editor, parent, originalCanonicalValue, cell, configRegistry);
        if (this.getNattableModelManager() != null && this.getNattableModelManager().getTable() != null) {
            this.setCreationContext(this.getNattableModelManager().getTable().getOwner());
        }
        return this.isEnabled();
    }

    public boolean isEnabled() {
        return true;
    }
}

