/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MimeType implements Enumerator
{
    APPLICATIONJSON(0, "applicationjson", "applicationjson"),
    APPLICATIONXLS(1, "applicationxls", "applicationxls"),
    APPLICATIONPDF(2, "applicationpdf", "applicationpdf"),
    APPLICATIONZIP(3, "applicationzip", "applicationzip"),
    APPLICATIONXML(4, "applicationxml", "applicationxml"),
    APPLICATIONIGES(5, "applicationiges", "applicationiges"),
    APPLICATIONSTEP(6, "applicationstep", "applicationstep"),
    IMAGEPNG(7, "imagepng", "imagepng"),
    IMAGEBMP(8, "imagebmp", "imagebmp"),
    IMAGEJPEG(9, "imagejpeg", "imagejpeg"),
    IMAGEGIF(10, "imagegif", "imagegif"),
    TEXTXML(11, "textxml", "textxml"),
    TEXTPLAIN(12, "textplain", "textplain"),
    TEXTHTML(13, "texthtml", "texthtml"),
    OTHER(14, "other", "other");

    public static final int APPLICATIONJSON_VALUE = 0;
    public static final int APPLICATIONXLS_VALUE = 1;
    public static final int APPLICATIONPDF_VALUE = 2;
    public static final int APPLICATIONZIP_VALUE = 3;
    public static final int APPLICATIONXML_VALUE = 4;
    public static final int APPLICATIONIGES_VALUE = 5;
    public static final int APPLICATIONSTEP_VALUE = 6;
    public static final int IMAGEPNG_VALUE = 7;
    public static final int IMAGEBMP_VALUE = 8;
    public static final int IMAGEJPEG_VALUE = 9;
    public static final int IMAGEGIF_VALUE = 10;
    public static final int TEXTXML_VALUE = 11;
    public static final int TEXTPLAIN_VALUE = 12;
    public static final int TEXTHTML_VALUE = 13;
    public static final int OTHER_VALUE = 14;
    private static final MimeType[] VALUES_ARRAY;
    public static final List<MimeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MimeType[]{APPLICATIONJSON, APPLICATIONXLS, APPLICATIONPDF, APPLICATIONZIP, APPLICATIONXML, APPLICATIONIGES, APPLICATIONSTEP, IMAGEPNG, IMAGEBMP, IMAGEJPEG, IMAGEGIF, TEXTXML, TEXTPLAIN, TEXTHTML, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MimeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MimeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MimeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MimeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MimeType get(int value) {
        switch (value) {
            case 0: {
                return APPLICATIONJSON;
            }
            case 1: {
                return APPLICATIONXLS;
            }
            case 2: {
                return APPLICATIONPDF;
            }
            case 3: {
                return APPLICATIONZIP;
            }
            case 4: {
                return APPLICATIONXML;
            }
            case 5: {
                return APPLICATIONIGES;
            }
            case 6: {
                return APPLICATIONSTEP;
            }
            case 7: {
                return IMAGEPNG;
            }
            case 8: {
                return IMAGEBMP;
            }
            case 9: {
                return IMAGEJPEG;
            }
            case 10: {
                return IMAGEGIF;
            }
            case 11: {
                return TEXTXML;
            }
            case 12: {
                return TEXTPLAIN;
            }
            case 13: {
                return TEXTHTML;
            }
            case 14: {
                return OTHER;
            }
        }
        return null;
    }

    private MimeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

